% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitHand.R
\name{fitHand}
\alias{fitHand}
\title{Best Fit Using Estimated Expected Effects}
\usage{
fitHand(handDose, handPct)
}
\arguments{
\item{handDose}{A numeric vector of doses for which expected effects are estimated from
a hand drawn line, must have at least two unique values.}

\item{handPct}{A numeric vector of the expected percent affected corresponding to (and
the same length as) \code{handDose}.}
}
\value{
A numeric vector of length two, the estimated intercept and slope of the
  dose-response curve on the log10-probit scale,
}
\description{
Use simple linear regression to describe
a hand draw line fit to a dose-effect experiment.
}
\examples{
d <- c(0.0625, 0.125, 0.25, 0.5, 1)
p <- c(9.5, 34, 67, 90.5, 98.6)
fitHand(handDose=d, handPct=p)
}

