% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_lucid.R
\name{plot.lucid}
\alias{plot.lucid}
\title{Visualize the LUCID model through a Sankey diagram
This function generates a Sankey diagram for the results of integrative clustering based on an \code{lucid} object}
\usage{
\method{plot}{lucid}(x, ...)
}
\arguments{
\item{x}{A model fitted by \code{\link{est.lucid}}}

\item{...}{Other parameters to be passed to \code{plot}}
}
\value{
A DAG graph created by \code{\link{sankeyNetwork}}
}
\description{
Visualize the LUCID model through a Sankey diagram
This function generates a Sankey diagram for the results of integrative clustering based on an \code{lucid} object
}
\examples{
\dontrun{
fit1 <- est.lucid(G = G1, Z = Z1, Y = Y1, CoY = CovY, K = 2, family = "binary")
plot(fit1)
}
}
\references{
Cheng Peng, Jun Wang, Isaac Asante, Stan Louie, Ran Jin, Lida Chatzi, Graham Casey, Duncan C Thomas, David V Conti, A Latent Unknown Clustering Integrating Multi-Omics Data (LUCID) with Phenotypic Traits, Bioinformatics, , btz667, https://doi.org/10.1093/bioinformatics/btz667.
}
\author{
Cheng Peng, Zhao Yang, David V. Conti
}
