% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_lucid.R
\name{est_lucid}
\alias{est_lucid}
\title{Estimating latent clusters with multi-omics data}
\usage{
est_lucid(
  G = NULL,
  CoG = NULL,
  Z = NULL,
  Y,
  CoY = NULL,
  useY = TRUE,
  family = "binary",
  K = 2,
  Pred = TRUE,
  initial = def_initial(),
  itr_tol = def_tol(),
  tunepar = def_tune()
)
}
\arguments{
\item{G}{Genetic features, a matrix}

\item{CoG}{Covariates to be included in the G->X path}

\item{Z}{Biomarker data, a matrix, can be incomplete and have missing values}

\item{Y}{Disease outcome, a vector}

\item{CoY}{Covariates to be included in the X->Y path}

\item{useY}{Using Y or not, default is TRUE}

\item{family}{"binary" or "normal" for Y}

\item{K}{Pre-specified # of latent clusters, default is 2}

\item{Pred}{Flag to compute posterior probability of latent cluster with fitted model, default is TRUE}

\item{initial}{A list of initial model parameters will be returned for integrative clustering}

\item{itr_tol}{A list of tolerance settings will be returned for integrative clustering}

\item{tunepar}{A list of tuning parameters and settings will be returned for integrative clustering}
}
\value{
\code{est_lucid} returns an object of list containing parameters estimates, predicted probability of latent clusters, and other features:
\item{beta}{Estimates of genetic effects, matrix}
\item{mu}{Estimates of cluster-specific biomarker means, matrix}
\item{sigma}{Estimates of cluster-specific biomarker covariance matrix, list}
\item{gamma}{Estimates of cluster-specific disease risk, vector}
\item{pcluster}{Probability of cluster, when G is null}
\item{pred}{Predicted probability of belonging to each latent cluster}
}
\description{
\code{est_lucid} estimates an integrated cluster assignment of genetic effects using complete biomarker data with/without disease outcomes. Options to produce sparse solutions for cluster-specific parameter estimates under a circumstance of analyzing high-dimensional data are also provided. An \code{IntClust} object will be produced.
}
\examples{
# Integrative clustering without feature selection
set.seed(10)
IntClusFit <- est_lucid(G=G1,Z=Z1,Y=Y1,K=2,family="binary",Pred=TRUE)

\dontrun{
# Re-run the model with covariates in the G->X path
IntClusCoFit1 <- est_lucid(G=G1,CoG=CoG,Z=Z1,Y=Y1,K=2,family="binary",Pred=TRUE)

# Re-run the model with covariates in the X->Y path
IntClusCoFit2 <- est_lucid(G=G1,Z=Z1,Y=Y1,CoY=CoY,K=2,family="binary",Pred=TRUE)

# Re-run the model with covariates in both G->X and X->Y paths
IntClusCoFit3 <- est_lucid(G=G1,CoG=CoG,Z=Z1,Y=Y1,CoY=CoY,K=2,family="binary",Pred=TRUE)

# Model fit with incomplete biomarker data and covariates in both G->X & X->Y paths
IntClusCoFit3_Incomp <- est_lucid(G=G1,CoG=CoG,Z=Z1_Incomp,Y=Y1,CoY=CoY,K=2,family="binary")
}
}
\references{
Cheng Peng, Jun Wang, Isaac Asante, Stan Louie, Ran Jin, Lida Chatzi, Graham Casey, Duncan C Thomas, David V Conti, A Latent Unknown Clustering Integrating Multi-Omics Data (LUCID) with Phenotypic Traits, Bioinformatics, , btz667, https://doi.org/10.1093/bioinformatics/btz667.
}
\author{
Cheng Peng, Zhao Yang, David V. Conti
}
\keyword{cluster}
\keyword{latent}
