% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.textmodel.R
\name{as.textmodel_lss}
\alias{as.textmodel_lss}
\title{Create a dummy textmodel_lss object from external objects}
\usage{
as.textmodel_lss(x, ...)
}
\arguments{
\item{x}{an object from which a dummy \link{textmodel_lss} object is created.}

\item{...}{arguments used to create a dummy object. \code{seeds} must be given
when \code{x} is a dense matrix.}
}
\value{
a dummy \link{textmodel_lss} object
}
\description{
Create a dummy textmodel_lss object from a numeric vector, dense matrix or an
existing textmodel_lss object. Pre-trained word-embedding models could used
to perform LSS through this function.
}
\details{
A named numeric vector and a dense matrix are set to \code{beta} and
\code{embedding} respectively. A dense matrix should have column names for
words.
}
\examples{
v <- c("a" = 0.1, "z" = -0.2, "d" = 0.3, "h" = -0.05)
lss <- as.textmodel_lss(v)

}
\keyword{internal}
