% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PIDD.R
\docType{data}
\name{PIDD}
\alias{PIDD}
\title{Pima Indians Diabetes Database}
\format{
768 rows, each of which is a woman 21 years or older. There are 9 variables:
\itemize{
\item \code{age} of the woman
\item \code{pregnancies}: number of previous pregnancies
\item \code{glucose}: glucose level
\item \code{BP}: systolic blood pressure
\item \code{skin_thickness}:
\item \code{insulin}:
\item \code{bmi}: Body mass index
\item \code{pedigree}: "Diabetes Pedigree Function"
\item \code{diabetes}: Did the patient develop diabetes during a 5-year follow-up?
}
}
\source{
\href{https://www.kaggle.com/datasets/uciml/pima-indians-diabetes-database/}{Kaggle}
}
\usage{
data(PIDD)
}
\description{
"The population for this study was the Pima Indian population near
Phoenix, Arizona. That population has been under continuous
study since 1965 by the National Institute of Diabetes and
Digestive and Kidney Diseases because of its high incidence rate
of diabetes. Each community resident over 5 years of age
was asked to undergo a standardized examination every two years,
which included an oral glucose tolerance test. Diabetes was
diagnosed according to World Health Organization Criteria;
that is, if the 2 hour post-load plasma glucose was at least 200
mg/dl (11.1 mmol/l) at any survey examination or if the Indian
Health Service Hospital serving the community found a glucose
concentration of at least 200 mg/dl during the course of routine
medical care." --- quoted from the reference below. The data were published by Kaggle for a machine-learning competition whose goal was
to develop a prediction function for diabetes.
}
\references{
Smith, J.W., Everhart, J.E., Dickson, W.C., Knowler, W.C., & Johannes, R.S. (1988)
"Using the ADAP learning algorithm to forecast the onset of diabetes mellitus"
\emph{Proceedings of the Symposium on Computer Applications and Medical Care}
}
\keyword{datasets}
