% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/LSD.align.R
\name{align}
\alias{LSD.align}
\alias{align}
\title{Visualize two-dimensional data in a color encoded fashion}
\usage{
align(input, colpal = "heat", simulate = FALSE, daltonize = FALSE,
  cvd = "p", alpha = NULL, label = FALSE, digits = 1, border = NULL,
  xlim = NULL, ylim = NULL, main = NULL, axes = TRUE, ...)
}
\arguments{
\item{input}{matrix or list with any type of entries.}

\item{colpal}{a character vector containing R built-in color names or a name of a \code{LSD} colorpalette as a character string (see disco() or \code{\link{disco}}).}

\item{simulate}{logical: if \code{TRUE} (\code{FALSE} by default), a converted colorpalette is used to simulate dichromat vision according to \url{http://www.daltonize.org} (see \code{\link{daltonize}}).}

\item{daltonize}{logical: if \code{TRUE} (\code{FALSE} by default), a converted colorpalette is used to enhance dichromat vision according to \url{http://www.daltonize.org} (see \code{\link{daltonize}}).}

\item{cvd}{character string implying the type of color vision deficiency ("p" for protanope, "d" for deuteranope or "t" for tritanope).}

\item{alpha}{alpha value: a two-digit integer between 01 and 99 for color opacity, i.e. appearance of partial or full transparency (usage omitted by default).}

\item{label}{logical: if \code{TRUE} (\code{FALSE} by default), labels are added according to the color scheme (i.e. binning).}

\item{digits}{integer indicating the number of decimals to be used for binning of continuous data.}

\item{border}{color for rectangle border(s). Use border = NA to omit borders.}

\item{xlim}{x limits, standard graphics parameter.}

\item{ylim}{y limits, standard graphics parameter.}

\item{main}{title of the plot, standard graphics parameter.}

\item{axes}{logical: if \code{TRUE} (by default), a box and axes are added to the plot (if \code{FALSE}, custom specification of axes can be achieved via basic R graphics functions).}

\item{...}{additional parameters to be passed to points and plot.}
}
\description{
Depict any matrix or list in a color encoded rectangular fashion.
}
\examples{
data(seqs)
colpal = c("A" = "darkgreen","C" = "darkblue","G" = "yellow","T" = "darkred")
align(seqs,colpal = colpal,label = TRUE,main = "DNA sequences")

data(homer)
colpal = c("white","black","yellow","wheat3")
align(homer,colpal = colpal,main = "D'OH!",asp = 1,axes = FALSE)
}
\author{
Phillipp Torkler, Bjoern Schwalb
}
\seealso{
\code{\link{clusterplot}}, \code{\link{demotour}}, \code{\link{disco}}, \code{\link{colorpalette}}
}
\keyword{alignment,}
\keyword{sequence}

