% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/LSD.comparisonplot.r
\name{comparisonplot}
\alias{comparisonplot}
\alias{cplot}
\title{Comparisonplot: a fancy scatterplot}
\usage{
comparisonplot(x, y, histbreaks = 30, adjust = 1, colpal = "heat",
  simulate = FALSE, daltonize = FALSE, cvd = "p", alpha = NULL,
  rev = FALSE, main = "comparisonplot", cor = FALSE, xlab = NULL,
  ylab = NULL, xlim = NULL, ylim = NULL, ab = FALSE,
  add.density = FALSE, col.density = "darkred", pimp = FALSE, ...)
}
\arguments{
\item{x}{a numeric vector.}

\item{y}{a numeric vector.}

\item{histbreaks}{a non-negative integer specifying the number of breaks of the histograms.}

\item{adjust}{scale the used bandwidth of the density estimate, if \code{add.density = TRUE}.}

\item{colpal}{a character vector containing R built-in color names or a name of a \code{LSD} colorpalette as a character string (see disco() or \code{\link{disco}}).}

\item{simulate}{logical: if \code{TRUE} (\code{FALSE} by default), a converted colorpalette is used to simulate dichromat vision according to \url{http://www.daltonize.org} (see \code{\link{daltonize}}).}

\item{daltonize}{logical: if \code{TRUE} (\code{FALSE} by default), a converted colorpalette is used to enhance dichromat vision according to \url{http://www.daltonize.org} (see \code{\link{daltonize}}).}

\item{cvd}{character string implying the type of color vision deficiency ("p" for protanope, "d" for deuteranope or "t" for tritanope).}

\item{alpha}{alpha value: a two-digit integer between 01 and 99 for color opacity, i.e. appearance of partial or full transparency (usage omitted by default).}

\item{rev}{logical: if \code{TRUE} (\code{FALSE} by default), a reversed colorpalette is used.}

\item{main}{title(s) of the plot, standard graphics parameter.}

\item{cor}{if \code{TRUE} (\code{FALSE} by default), the correlation is added to the title.}

\item{xlab}{x label, standard graphics parameter.}

\item{ylab}{y label, standard graphics parameter.}

\item{xlim}{x limits, standard graphics parameter.}

\item{ylim}{y limits, standard graphics parameter.}

\item{ab}{if \code{TRUE} (\code{FALSE} by default), \code{abline(0,1)} is added to the heatscatter.}

\item{add.density}{if \code{TRUE} (\code{FALSE} by default), density lines are added to the barplots.}

\item{col.density}{R built-in color to specify the color of the density line.}

\item{pimp}{if \code{TRUE} (\code{FALSE} by default), the plot is pimped.}

\item{...}{additional parameters to be passed to points and plot.}
}
\description{
A function to compare two vectors extensively.
}
\examples{
points = 10^4
x = c(rnorm(points/2),rnorm(points/2)+4)
y = x + rnorm(points,sd=0.8)
x = sign(x)*abs(x)^1.3

comparisonplot(x,y,histbreaks=30,pch=20)
}
\author{
Bjoern Schwalb
}
\seealso{
\code{\link{align}}, \code{\link{demotour}}, \code{\link{disco}}, \code{\link{colorpalette}}
}
\keyword{barplot}
\keyword{scatterplot,}

