% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/LSD.color.r
\name{colorpalette}
\alias{LSD.colorpalette}
\alias{colorpalette}
\title{Provides colorpalettes containing R built-in colors}
\usage{
colorpalette(colpal, nrcol = NULL, simulate = FALSE, daltonize = FALSE,
  cvd = "p", alpha = NULL, rev = FALSE)
}
\arguments{
\item{colpal}{a character vector containing R built-in color names or a name of a \code{LSD} colorpalette as a character string (see disco() or \code{\link{disco}}).}

\item{nrcol}{a non-negative integer specifying the number of colors to be used (defaults to length of \code{colpal}, if not specified).}

\item{simulate}{logical: if \code{TRUE} (\code{FALSE} by default), a converted colorpalette is returned to simulate dichromat vision according to \url{http://www.daltonize.org} (see \code{\link{daltonize}}).}

\item{daltonize}{logical: if \code{TRUE} (\code{FALSE} by default), a converted colorpalette is returned to enhance dichromat vision according to \url{http://www.daltonize.org} (see \code{\link{daltonize}}).}

\item{cvd}{character string implying the type of color vision deficiency ("p" for protanope, "d" for deuteranope or "t" for tritanope).}

\item{alpha}{alpha value: a two-digit integer between 01 and 99 for color opacity, i.e. appearance of partial or full transparency (usage omitted by default).}

\item{rev}{logical: if \code{TRUE} (\code{FALSE} by default), a reversed colorpalette is returned.}
}
\value{
\code{colorpalette} returns a vector containing R built-in colors in hexadecimal representation.
}
\description{
Provides pre-designed colorpalettes (character vectors containing R built-in colors) of this and several other R packages (grDevices, RColorBrewer, colorRamps) as well as custom-made ones.
}
\examples{
colorpalette("heat")
colorpalette(c("darkred","grey","darkblue"),10)
}
\author{
Achim Tresch, Bjoern Schwalb
}
\seealso{
\code{\link{disco}}, \code{\link{demotour}}
}
\keyword{alpha}
\keyword{color,}

