% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binomial_tests.R
\name{binomial_p_lr_test}
\alias{binomial_p_lr_test}
\title{Test p of a binomial distribution using the likelihood ratio test.}
\source{
\url{https://en.wikipedia.org/wiki/Likelihood-ratio_test}
}
\usage{
binomial_p_lr_test(x, n, p, alternative = "two.sided", conf.level = 0.95)
}
\arguments{
\item{x}{Number of successes.}

\item{n}{Number of trials.}

\item{p}{Hypothesized probability of success.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of "two.sided" (default), "greater" or "less".}

\item{conf.level}{confidence level of the likelihood interval.}
}
\value{
An S3 class containing the test statistic, p value, likelihood based confidence interval, and alternative
hypothesis.
}
\description{
Test p of a binomial distribution using the likelihood ratio test.
}
\examples{
library(LRTesteR)

# Null is true. 52 successes. 100 trials
binomial_p_lr_test(52, 100, .50, "two.sided")

# Null is false. 75 successes. 100 trials
binomial_p_lr_test(75, 100, .50, "two.sided")
}
