% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile.R
\name{profile.lmm}
\alias{profile.lmm}
\title{Evaluate Contour of the Log-Likelihood}
\usage{
\method{profile}{lmm}(
  fitted,
  effects = NULL,
  profile.likelihood = FALSE,
  maxpts = NULL,
  conf.level = 0.95,
  trace = FALSE,
  transform.sigma = NULL,
  transform.k = NULL,
  transform.rho = NULL,
  transform.names = TRUE,
  ...
)
}
\arguments{
\item{fitted}{a \code{lmm} object.}

\item{effects}{[character vector] name of the parameters who will be constrained.
Alternatively can be the type of parameters, e.g. \code{"mean"}, \code{"variance"}, \code{"correlation"}, or \code{"all"}.}

\item{profile.likelihood}{[logical] should profile likelihood be performed? Otherwise varying one parameter at a time around the MLE while keeping the other constant).}

\item{maxpts}{[integer, >0] number of points use to discretize the likelihood, \code{maxpts} points smaller than the MLE and \code{maxpts} points higher than the MLE.}

\item{conf.level}{[numeric, 0-1] the confidence level of the confidence intervals used to decide about the range of values for each parameter.}

\item{trace}{[logical] Show the progress of the execution of the function.}

\item{transform.sigma}{[character] Transformation used on the variance coefficient for the reference level. One of \code{"none"}, \code{"log"}, \code{"square"}, \code{"logsquare"} - see details.}

\item{transform.k}{[character] Transformation used on the variance coefficients relative to the other levels. One of \code{"none"}, \code{"log"}, \code{"square"}, \code{"logsquare"}, \code{"sd"}, \code{"logsd"}, \code{"var"}, \code{"logvar"} - see details.}

\item{transform.rho}{[character] Transformation used on the correlation coefficients. One of \code{"none"}, \code{"atanh"}, \code{"cov"} - see details.}

\item{transform.names}{[logical] Should the name of the coefficients be updated to reflect the transformation that has been used?}

\item{...}{Not used. For compatibility with the generic method.}
}
\value{
A data.frame object containing the log-likelihood for various parameter values.
}
\description{
Display the (restricted) log-likelihood around Maximum Likelihood Estimate (MLE) under specific constrains.
}
\details{
Each parameter defined by the argument \code{effets} is treated separately:\itemize{
\item the confidence interval of a parameter is discretized with \code{maxpt} points,
\item this parameter is set to a discretization value.
\item the other parameters are either set to the (unconstrained) MLE (\code{profile.likelihood=FALSE})
or to constrained MLE  (\code{profile.likelihood=TRUE}). The latter case is much more computer intensive as it implies re-running the estimation procedure.
\item the (restricted) log-likelihood is evaluated.
}
}
\examples{
data(gastricbypassW, package = "LMMstar")
e.lmm <- lmm(weight2 ~ weight1 + glucagonAUC1,
             data = gastricbypassW, control = list(optimizer = "FS"))

## profile logLiklihood
\dontrun{
e.pro <- profile(e.lmm, effects = "all", maxpts = 10, profile.likelihood = TRUE)
head(e.pro)
plot(e.pro)
}

## along a single parameter axis
e.sliceNone <- profile(e.lmm, effects = "all", maxpts = 10, transform.sigma = "none")
plot(e.sliceNone)
e.sliceLog <- profile(e.lmm, effects = "all", maxpts = 10, transform.sigma = "log")
plot(e.sliceLog)

}
\keyword{htest}
