% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlmm.R
\name{mlmm}
\alias{mlmm}
\title{Fit Multiple Linear Mixed Model}
\usage{
mlmm(
  ...,
  data,
  by,
  contrast.rbind = NULL,
  effects = NULL,
  robust = FALSE,
  df = TRUE,
  ci = TRUE,
  name.short = c(TRUE, TRUE),
  transform.sigma = NULL,
  transform.k = NULL,
  transform.rho = NULL,
  transform.names = TRUE,
  trace = TRUE
)
}
\arguments{
\item{...}{arguments passed to \code{\link{lmm}}.}

\item{data}{[data.frame] dataset (in the long format) containing the observations.}

\item{by}{[character] variable used to split the dataset. On each split a seperate linear mixed model is fit.}

\item{contrast.rbind}{[character or numeric matrix] Contrast to be be applied to compare the groups.
Argument passed to the argument \code{effects} of \code{\link{rbind.Wald_lmm}}.
Right hand side can be specified via an attribute \code{"rhs"}.}

\item{effects}{[character or numeric matrix] Linear combinations of coefficients relative to which Wald test should be computed.
Argument passed to \code{\link{anova.lmm}}.
Right hand side can be specified via an attribute \code{"rhs"}.}

\item{robust}{[logical] Should robust standard errors (aka sandwich estimator) be output instead of the model-based standard errors.
Argument passed to \code{\link{anova.lmm}}.}

\item{df}{[logical] Should the degree of freedom be computed using a Satterthwaite approximation?
Argument passed to \code{\link{anova.lmm}}.}

\item{ci}{[logical] Should a confidence interval be output for each hypothesis?
Argument passed to \code{\link{anova.lmm}}.}

\item{name.short}{[logical vector of length 2] use short names for the output coefficients:
omit the name of the by variable, omit the regression variable name when the same regression variable is used in all models.}

\item{transform.sigma, transform.k, transform.rho, transform.names}{[character] transformation used on certain type of parameters.}

\item{trace}{[interger, >0] Show the progress of the execution of the function.}
}
\description{
Fit several linear mixed models, extract relevant coefficients, and combine them into a single table.
}
\details{
\bold{Grouping variable} in argument repetition: when numeric, it will be converted into a factor variable, possibly adding a leading 0 to preserve the ordering.
This transformation may cause inconsistency when combining results between different \code{lmm} object. 
This is why the grouping variable should preferably be of type character or factor.
}
\examples{
#### univariate regression ####
if(require(lava) && require(multcomp)){

set.seed(10)
d1 <- cbind(sim(lvm(Y~0.5*X1), 25), group = "A")
d2 <- cbind(sim(lvm(Y~0.1*X1), 100), group = "B")
d3 <- cbind(sim(lvm(Y~0.01*X1), 1000), group = "C")
d1$id <- 1:NROW(d1)
d2$id <- 1:NROW(d2)
d3$id <- 1:NROW(d3)

d <- rbind(d1,d2,d3)

e.mlmm <- mlmm(Y~X1, data = d, by = "group", effects = "X1=0")
summary(e.mlmm)
summary(e.mlmm, method = "single-step")
summary(e.mlmm, method = "single-step2")

## re-work contrast
summary(anova(e.mlmm, effects = mcp(X1 = "Dunnett")), method = "none")
## summary(mlmm(Y~X1, data = d, by = "group", effects = mcp(X1="Dunnett")))
}

#### multivariate regression ####
set.seed(10)
dL <- sampleRem(250, n.times = 3, format = "long")

e.mlmm <- mlmm(Y~X1+X2+X6, repetition = ~visit|id, data = dL,
               by = "X4", structure = "CS")
summary(e.mlmm)

e.mlmmX1 <- mlmm(Y~X1+X2+X6, repetition = ~visit|id, data = dL,
               by = "X4", effects = "X1=0", structure = "CS")
summary(e.mlmmX1)
summary(e.mlmmX1, method = "single-step")

}
\seealso{
\code{\link{confint.mlmm}} for a data.frame containing estimates with their uncertainty. \cr
\code{\link{summary.mlmm}} for a summary of the model and estimates. \cr
\code{\link{autoplot.Wald_lmm}} for a graphical display. \cr
}
\keyword{models}
