% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmmCC.R
\name{lmmCC}
\alias{lmmCC}
\alias{lmmCC.formula}
\alias{lmmCC.lm}
\title{Fit Linear Mixed Model on Complete Case data}
\usage{
lmmCC(object, ...)

\method{lmmCC}{formula}(
  object,
  repetition,
  data,
  lm.change = FALSE,
  df = NULL,
  trace = TRUE,
  control = NULL,
  ...
)

\method{lmmCC}{lm}(
  object,
  repetition,
  data,
  name.time = "time",
  df = NULL,
  trace = TRUE,
  control = NULL,
  ...
)
}
\arguments{
\item{object}{[formula] Specify the model for the mean.
On the left hand side the outcome and on the right hand side the covariates affecting the mean value.
E.g. Y ~ Gender + Gene.}

\item{...}{Not used. For compatibility with the generic method.}

\item{repetition}{[formula] Specify the structure of the data: the time/repetition variable and the grouping variable, e.g. ~ time|id.}

\item{data}{[data.frame] dataset (in the long format) containing the observations.}

\item{lm.change}{[logical] Should a linear model on the change in outcome be estimated. Only possible with two repetitions.
Will match the mixed model if the later includes repetition-dependent effects for all covariates.}

\item{df}{[logical] Should the degree of freedom be computed using a Satterthwaite approximation?}

\item{trace}{[interger, >0] Show the progress of the execution of the function.}

\item{control}{[list] Control values for the optimization method.
The element \code{optimizer} indicates which optimizer to use and additional argument will be pass to the optimizer.}

\item{name.time}{[character] name of the time variable.}
}
\value{
A \code{lmmCC} object, which inherits from \code{lmm}.
}
\description{
Fit a linear mixed model on the complete case data.
Mostly useful as a sanity check, to match the results of a univariate analysis on the change.
}
\examples{
#### 1- simulate data in the wide format ####
set.seed(10)
dW <- sampleRem(100, n.times = 3, format = "wide")
dW$Y3[1:10] <- NA
dW$change2 <- dW$Y2 - dW$Y1
dW$change3 <- dW$Y3 - dW$Y1

e.lm2 <- lm(change2 ~ X1 + X2, data = dW)
summary(e.lm2)$coef
e.lm3 <- lm(change3 ~ X1 + X2, data = dW)
summary(e.lm3)$coef

#### 2- complete case LMM from LM ####
e.lmmCC2 <- lmmCC(e.lm2, repetition = change2~Y2-Y1)
model.tables(e.lmmCC2)
e.lmmCC3 <- lmmCC(e.lm3, repetition = change3~Y3-Y1)
model.tables(e.lmmCC3)

#### 3- complete case LMM ####
dL <- reshape(dW[,c("id","X1","X2","Y1","Y2","Y3")],
              direction = "long", 
              varying = c("Y1","Y2","Y3"), sep = "", idvar = "id")
dL$time <- as.character(dL$time)

e.lmm2 <- lmmCC(Y ~ time + time*X1 + time*X2, repetition = ~time|id,
                data = dL[dL$time \%in\% 1:2,])
model.tables(e.lmm2)
e.lmm3.bis <- lmmCC(Y ~ time + time*X1 + time*X2, repetition = ~time|id,
                data = dL[dL$time \%in\% c(1,3),], lm.change = TRUE)
model.tables(e.lmm3.bis)
e.lmm3.bis$lm.change

}
\keyword{models}
