% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.lmm}
\alias{summary.lmm}
\title{Summary Output for a Linear Mixed Model}
\usage{
\method{summary}{lmm}(
  object,
  level = 0.95,
  robust = FALSE,
  print = TRUE,
  columns = NULL,
  digits = 3,
  digits.df = 1,
  digits.p.value = 3,
  hide.data = FALSE,
  hide.fit = FALSE,
  hide.cor = NULL,
  type.cor = NULL,
  hide.var = NULL,
  hide.sd = NULL,
  hide.re = NULL,
  hide.mean = FALSE,
  ...
)
}
\arguments{
\item{object}{[lmm] output of the \code{lmm} function.}

\item{level}{[numeric,0-1] confidence level for the confidence intervals.}

\item{robust}{[logical] Should robust standard errors (aka sandwich estimator) be output instead of the model-based standard errors.}

\item{print}{[logical] should the output be printed in the console.}

\item{columns}{[character vector] Columns to be output for the fixed effects.
Can be any of \code{"estimate"}, \code{"se"}, \code{"statistic"}, \code{"df"}, \code{"null"}, \code{"lower"}, \code{"upper"}, \code{"p.value"}.}

\item{digits}{[interger, >0] number of digits used to display estimates.}

\item{digits.df}{[interger, >0] number of digits used to display degrees of freedom.}

\item{digits.p.value}{[interger, >0] number of digits used to display p-values.}

\item{hide.data}{[logical] should information about the dataset not be printed.}

\item{hide.fit}{[logical] should information about the model fit not be printed.}

\item{hide.cor}{[logical] should information about the correlation structure not be printed.}

\item{type.cor}{[character] should the correlation matrix be display (\code{"matrix"}) or the parameter values (\code{"param"}).}

\item{hide.var}{[logical] should information about the variance not be printed.}

\item{hide.sd}{[logical] should information about the standard deviation not be printed.}

\item{hide.re}{[logical] should information about the random effect not be printed.}

\item{hide.mean}{[logical] should information about the mean structure not be printed.}

\item{...}{not used. For compatibility with the generic function.}
}
\value{
A list containing elements displayed in the summary: \itemize{
\item \code{correlation}: the correlation structure.
\item \code{variance}: the variance structure.
\item \code{sd}: the variance structure expressed in term of standard deviations.
\item \code{mean}: the mean structure.
}
}
\description{
Summary output for a linear mixed model fitted with \code{lmm}.
}
\keyword{methods}
