% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.Wald_lmm}
\alias{summary.Wald_lmm}
\title{Summary of Testing for a Linear Mixed Models}
\usage{
\method{summary}{Wald_lmm}(
  object,
  print = TRUE,
  seed = NULL,
  columns = NULL,
  legend = TRUE,
  digits = 3,
  digits.df = 1,
  digits.p.value = 3,
  sep = ": ",
  ...
)
}
\arguments{
\item{object}{an \code{Wald_lmm} object, output of \code{anova}.}

\item{print}{[logical] should the output be printed in the console.
Can be a vector of length 2 where the first element refer to the global tests and the second to the individual tests.}

\item{seed}{[integer] value that will be set before adjustment for multiple comparisons to ensure reproducible results.
Can also be \code{NULL}: in such a case no seed is set.}

\item{columns}{[character vector] Columns to be displayed for each null hypothesis.
Can be any of \code{"type"}, \code{"estimate"}, \code{"se"}, \code{"statistic"}, \code{"df"}, \code{"null"}, \code{"lower"}, \code{"upper"}, \code{"p.value"}.##'}

\item{legend}{[logical] should explanations about the content of the table be displayed.}

\item{digits}{[interger, >0] number of digits used to display estimates.}

\item{digits.df}{[interger, >0] number of digits used to display degrees of freedom.}

\item{digits.p.value}{[interger, >0] number of digits used to display p-values.}

\item{sep}{[character] character string used to separate the type of test (e.g. mean, variance) and the name of the test.}

\item{...}{arguments \code{method}, \code{level}, and \code{backtransform} passed to \code{\link{confint.Wald_lmm}}}
}
\value{
\code{NULL}
}
\description{
Estimates, p-values, and confidence intevals for linear hypothesis testing, possibly adjusted for multiple comparisons.
}
\details{
By default adjustment for multiple comparisons via a single step max-test adjustment,
either using the multcomp package (equal degrees of freedom) or the copula package (unequal degrees of freedom).
When multiple multivariate Wald tests are performed, adjustment for multiple comparisons for the univariate Wald tests is performed within each multivariate Wald test.
The number of tests ajusted for equal the first degree of freedom of the multivariate Wald statistic.

Adding the value \code{"type"} in argument \code{"columns"} ensures that the type of parameter that is being test (mean, variance, correlation) is output.
}
