% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.lmm.R
\name{summary}
\alias{summary}
\alias{summary.lmm}
\title{Summary Output for a Linear Mixed Model}
\usage{
\method{summary}{lmm}(
  object,
  digit = 3,
  level = 0.95,
  type.cor = NULL,
  robust = FALSE,
  print = TRUE,
  columns = NULL,
  hide.data = FALSE,
  hide.fit = FALSE,
  hide.cor = is.null(object$formula$cor),
  hide.var = TRUE,
  hide.sd = FALSE,
  hide.mean = FALSE,
  ...
)
}
\arguments{
\item{object}{[lmm] output of the \code{lmm} function.}

\item{digit}{[integer,>0] number of digit used to display numeric values.}

\item{level}{[numeric,0-1] confidence level for the confidence intervals.}

\item{type.cor}{[character] should the correlation matrix be display (\code{"matrix"}) or the parameter values (\code{"param"}).}

\item{robust}{[logical] Should robust standard errors (aka sandwich estimator) be output instead of the model-based standard errors.}

\item{print}{[logical] should the output be printed in the console.}

\item{columns}{[character vector] Columns to be output for the fixed effects. Can be any of \code{"estimate"}, \code{"se"}, \code{"statistic"}, \code{"df"}, \code{"null"}, \code{"lower"}, \code{"upper"}, \code{"p.value"}.}

\item{hide.data}{[logical] should information about the dataset not be printed.}

\item{hide.fit}{[logical] should information about the model fit not be printed.}

\item{hide.cor}{[logical] should information about the correlation structure not be printed.}

\item{hide.var}{[logical] should information about the variance not be printed.}

\item{hide.sd}{[logical] should information about the standard deviation not be printed.}

\item{hide.mean}{[logical] should information about the mean structure not be printed.}

\item{...}{not used. For compatibility with the generic function.}
}
\value{
A list containing elements displayed in the summary: \itemize{
\item \code{correlation}: the correlation structure.
\item \code{variance}: the variance structure.
\item \code{sd}: the variance structure expressed in term of standard deviations.
\item \code{mean}: the mean structure.
}
}
\description{
Summary output for a linear mixed model fitted with \code{lmm}.
This is a modified version of the \code{nlme::summary.gls} function.
}
