% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partialCor.R
\name{partialCor}
\alias{partialCor}
\title{Partial Correlation}
\usage{
partialCor(formula, data, repetition)
}
\arguments{
\item{formula}{a formula with in the left hand side the variables for which the correlation should be computed
and on the right hand side the adjustment set. Can also be a list of formula for outcome-specific adjustment set.}

\item{data}{[data.frame] dataset containing the variables.}

\item{repetition}{[formula] Specify the structure of the data: the time/repetition variable and the grouping variable, e.g. ~ time|id.}
}
\description{
Estimate the partial correlation between two variables where the adjustment set may differ between variables.
}
\details{
Fit a mixed model to estimate the partial correlation which can be time consuming.
}
\examples{
#### bivariate (no repetition) ####
## example from ppcor::pcor 
y.data <- data.frame(
  hl=c(7,15,19,15,21,22,57,15,20,18),
  disp=c(0.000,0.964,0.000,0.000,0.921,0.000,0.000,1.006,0.000,1.011),
  deg=c(9,2,3,4,1,3,1,3,6,1),
  BC=c(1.78e-02,1.05e-06,1.37e-05,7.18e-03,0.00e+00,0.00e+00,0.00e+00
,  4.48e-03,2.10e-06,0.00e+00)
)

## ppcor::pcor(y.data)
## estimate
##              hl       disp        deg        BC
## hl    1.0000000 -0.6720863 -0.6161163 0.1148459
## disp -0.6720863  1.0000000 -0.7215522 0.2855420
## deg  -0.6161163 -0.7215522  1.0000000 0.6940953
## BC    0.1148459  0.2855420  0.6940953 1.0000000

## $p.value
##              hl       disp        deg         BC
## hl   0.00000000 0.06789202 0.10383620 0.78654997
## disp 0.06789202 0.00000000 0.04332869 0.49299871
## deg  0.10383620 0.04332869 0.00000000 0.05615021
## BC   0.78654997 0.49299871 0.05615021 0.00000000

set.seed(10)
y.data$gender <- factor(rbinom(10, size = 1, prob = 0.5), labels = c("F","M"))

partialCor(c(hl,disp)~BC+deg, data = y.data)
partialCor(hl + disp~BC+deg, data = y.data)

partialCor(list(hl~BC+deg, disp~BC), data = y.data)
partialCor(list(hl~BC+deg+gender, disp~1), data = y.data)

#### bivariate (with repetition) ####
data(gastricbypassL, package = "LMMstar")

partialCor(weight+glucagonAUC~time, data = gastricbypassL)

partialCor(weight+glucagonAUC~time, repetition =~time|id, data = gastricbypassL)
}
