% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structure.R
\name{CS}
\alias{CS}
\title{Compound Symmetry Structure}
\usage{
CS(formula, var.cluster, var.time, ...)
}
\arguments{
\item{formula}{formula indicating on which variable to stratify the residual variance and correlation (left hand side)
and variables influencing the residual variance (right hand side).}

\item{var.cluster}{[character] cluster variable.}

\item{var.time}{[character] time variable.}

\item{...}{Not used. For compatibility with other structures.}
}
\value{
An object of class \code{CS} that can be passed to the argument \code{structure} of the \code{lmm} function.
}
\description{
Variance-covariance structure where the residuals have constant variance and correlation.
Can be stratified on a categorical variable.
}
\details{
A typical formula would be \code{~1}, indicating a variance constant over time and the same correlation between all pairs of times.
}
\examples{
CS(~1, var.cluster = "id", var.time = "time")
CS(gender~1, var.cluster = "id", var.time = "time")
CS(list(~time,~1), var.cluster = "id", var.time = "time")
CS(list(gender~time,gender~1), var.cluster = "id", var.time = "time")

}
