% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LLMR.R
\name{llm_config}
\alias{llm_config}
\title{Create an LLM configuration (provider-agnostic)}
\usage{
llm_config(
  provider,
  model,
  api_key = NULL,
  troubleshooting = FALSE,
  base_url = NULL,
  embedding = NULL,
  no_change = FALSE,
  ...
)
}
\arguments{
\item{provider}{Character scalar. One of:
\code{"openai"}, \code{"anthropic"}, \code{"gemini"}, \code{"groq"}, \code{"together"},
\code{"voyage"} (embeddings only), \code{"deepseek"}, \code{"xai"}.}

\item{model}{Character scalar. Model name understood by the chosen provider.
(e.g., \code{"gpt-4o-mini"}, \code{"o4-mini"}, \code{"claude-3.7"}, \code{"gemini-2.0-flash"}, etc.)}

\item{api_key}{Character scalar. Provider API key.}

\item{troubleshooting}{Logical. If \code{TRUE}, prints the full request payloads
(including your API key!) for debugging. \strong{Use with extreme caution.}}

\item{base_url}{Optional character. Back-compat alias; if supplied it is
stored as \code{api_url} in \code{model_params} and overrides the default endpoint.}

\item{embedding}{\code{NULL} (default), \code{TRUE}, or \code{FALSE}. If \code{TRUE}, the call
is routed to the provider's embeddings API; if \code{FALSE}, to the chat API.
If \code{NULL}, LLMR infers embeddings when \code{model} contains \code{"embedding"}.}

\item{no_change}{Logical. If \code{TRUE}, LLMR \strong{never} auto-renames/adjusts
provider parameters. If \code{FALSE} (default), well-known compatibility shims
may apply (e.g., renaming OpenAI's \code{max_tokens} → \code{max_completion_tokens}
after a server hint; see \code{call_llm()} notes).}

\item{...}{Additional provider-specific parameters (e.g., \code{temperature},
\code{top_p}, \code{max_tokens}, \code{top_k}, \code{repetition_penalty}, \code{reasoning_effort},
\code{api_url}, etc.). Values are forwarded verbatim unless documented shims apply.}
}
\value{
An object of class \code{c("llm_config", provider)}. Fields:
\code{provider}, \code{model}, \code{api_key}, \code{troubleshooting}, \code{embedding},
\code{no_change}, and \code{model_params} (a named list of extras).
}
\description{
\code{llm_config()} builds a provider-agnostic configuration object that
\code{call_llm()} (and friends) understand. You can pass provider-specific
parameters via \code{...}; LLMR forwards them as-is, with a few safe conveniences.
}
\section{Temperature range clamping}{

Anthropic temperatures must be in \verb{[0, 1]}; others in \verb{[0, 2]}. Out-of-range
values are clamped with a warning.
}

\section{Endpoint overrides}{

You can pass \code{api_url} (or \verb{base_url=} alias) in \code{...} to point to gateways
or compatible proxies.
}

\examples{
\dontrun{
# Basic OpenAI config
cfg <- llm_config("openai", "gpt-4o-mini",
temperature = 0.7, max_tokens = 300)

# Generative call returns an llmr_response object
r <- call_llm(cfg, "Say hello in Greek.")
print(r)
as.character(r)

# Embeddings (inferred from the model name)
e_cfg <- llm_config("gemini", "text-embedding-004")

# Force embeddings even if model name does not contain "embedding"
e_cfg2 <- llm_config("voyage", "voyage-large-2", embedding = TRUE)
}
}
\seealso{
\code{\link{call_llm}},
\code{\link{call_llm_robust}},
\code{\link{llm_chat_session}},
\code{\link{call_llm_par}},
\code{\link{get_batched_embeddings}}
}
