% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LLM_parallel_utils.R
\name{call_llm_broadcast}
\alias{call_llm_broadcast}
\title{Mode 2: Message Broadcast - Fixed Config, Multiple Messages}
\usage{
call_llm_broadcast(config, messages_list, ...)
}
\arguments{
\item{config}{Single llm_config object to use for all calls.}

\item{messages_list}{A list of message lists, each for one API call.}

\item{...}{Additional arguments passed to `call_llm_par` (e.g., tries, verbose, progress).}
}
\value{
A tibble with columns: message_index (metadata), provider, model,
  all model parameters, response_text, raw_response_json, success, error_message.
}
\description{
Broadcasts different messages using the same configuration in parallel.
Perfect for batch processing different prompts with consistent settings.
This function requires setting up the parallel environment using `setup_llm_parallel`.
}
\examples{
\dontrun{
  # Broadcast different questions
  config <- llm_config(provider = "openai", model = "gpt-4o-mini",
                       api_key = Sys.getenv("OPENAI_API_KEY"))

  messages_list <- list(
    list(list(role = "user", content = "What is 2+2?")),
    list(list(role = "user", content = "What is 3*5?")),
    list(list(role = "user", content = "What is 10/2?"))
  )

  setup_llm_parallel(workers = 4, verbose = TRUE)
  results <- call_llm_broadcast(config, messages_list)
  reset_llm_parallel(verbose = TRUE)
}
}
