\name{Xsample}
\alias{Xsample}
\title{
  Generates a random sample of the unknowns for a linear inverse problem
}
\description{
  Given an inverse input list, randomly samples the unknowns,
  using an MCMC method
}

\usage{
Xsample(lim, exact = NULL, ...)
}
\arguments{
  \item{lim }{a list that contains the linear inverse model
    specification, as  generated by function \code{setup.limfile}.
  }
  \item{exact }{if not \code{NULL}, a vector containing the numbers of
    the equations to be solved exactly; if \code{NULL}, all equations
    are considered exact.
  }
  \item{... }{extra parameters passed to function
    \code{\link[limSolve]{xsample}} from package\code{limSolve}.
  }
}
\value{
  a 2-columned vector containing the minimum (column 1) and
  maximum (column 2) of each unknown.
}

\author{
  Karline Soetaert <k.soetaert@nioo.knaw.nl>
}
\examples{# sample solution space
  xs <- Xsample(LIMRigaAutumn, iter = 500, jmp = 5)
  # remove flows that are invariable (sd=0)
  xs <- xs[ ,-which( sd(xs)==0 )]
  #pairs plot
  pairs(xs, gap = 0, pch = ".", upper.panel = NULL)
}

\details{
  For overdetermined LIM problems, the inverse equations may be split up
  in equations which have to be exactly met and other equations which have
  to be approximated.

  \code{exact} is a vector with the exact equations
 
  The default settings of \code{xsample} will often not do.
  For instance, the default consists of 3000 iterations (\code{iter}) and
  a jump length of \code{jmp} of 0.1.
  You may need to increase one of those to ensure that the
  entire solution space has been adequately sampled.
}

\seealso{
  \code{\link{Varranges}} which estimates the ranges of inverse variables

  \code{\link{Plotranges}} to plot the ranges

  function \code{\link[limSolve]{xsample}} from package\code{limSolve}
}
\references{
  Van den Meersche K, Soetaert K, Van Oevelen D (2009). xsample(): An R
  Function for Sampling Linear Inverse Problems.
  Journal of Statistical Software, Code Snippets, 30(1), 1-15.

\url{http://www.jstatsoft.org/v30/c01/}
}

\keyword{optimize}
\keyword{utilities}

