\name{Lsei}
\alias{Lsei}
\alias{Lsei.lim}
\alias{Lsei.limfile}
\alias{Lsei.character}
\alias{Lsei.double}
\title{Solves a linear inverse model using the least squares method}
\description{Solves a linear inverse model using the least squares method
  \cr Input presented as:
  \item matrices E, F, A, B, G, H (Lsei.double) or
  \item a list (Lsei.lim) or
  \item as a lim input file (Lsei.limfile)
  \cr Useful for solving overdetermined food webs.}
\usage{
Lsei(...)
Lsei.double(...)
Lsei.lim(lim, exact=NULL, parsimonious = FALSE, ...)
Lsei.limfile(file, exact=NULL, parsimonious = FALSE, 
             verbose=TRUE, ...)
Lsei.character(...)}
\arguments{
  \item{lim }{a list that contains the linear inverse model specification, as  generated by function \code{Setup}}
  \item{exact }{if not null, a vector containing the numbers of the equations to be solved exactly; if NULL, all equations are considered exact}
  \item{parsimonious }{if TRUE, also minimises the sum of squared unknowns}
  \item{file }{name of the inverse input file}
  \item{verbose }{if TRUE: when reading the file prints warnings and messages to the screen}
  \item{... }{other arguments passed to function \code{\link[limSolve]{lsei}} from package\code{limSolve}}
}
\value{
  a list containing:
  \item{X }{vector containing the solution of the least squares problem.}
  \item{residualNorm }{scalar, the sum of residuals of equalities and violated inequalities}
  \item{solutionNorm }{scalar, the value of the minimised quadratic function at the solution}
  \item{IsError }{if an error occurred}
  \item{Error }{error text}
  \item{type }{lsei}
}
\author{Karline Soetaert <k.soetaert@nioo.knaw.nl>}
\examples{Lsei.lim(LIMRigaAutumn,parsimonious=TRUE)}
\references{K. H. Haskell and R. J. Hanson, An algorithm for linear least squares problems with equality and
nonnegativity constraints, Report SAND77-0552, Sandia Laboratories, June 1978.
\cr K. H. Haskell and R. J. Hanson, Selected algorithms for the linearly constrained least squares problem - a
users guide, Report SAND78-1290, Sandia Laboratories,August 1979.
\cr K. H. Haskell and R. J. Hanson, An algorithm for linear least squares problems with equality and
nonnegativity constraints, Mathematical Programming 21 (1981), pp. 98-118.
\cr R. J. Hanson and K. H. Haskell, Two algorithms for the linearly constrained least squares problem, ACM
Transactions on Mathematical Software, September 1982.}
\details{Solves the following inverse problem:
 \deqn{\min(||AAx-BB||^2)}, the approximate equations
   subject to        
 \deqn{Ex=F}, the mass balances
 \deqn{Gx>=H}, the constraints.

and where E and F make up the equations from A and B, as specified by vector *exact*
\cr AA and BB are the equations from A and B, NOT specified by vector *exact*

in case exact = NULL, there are no approximate equations.

in case parsimonious=TRUE, then the sum of squared unknowns is also minimised. This means that AA is 
augmented with the unity matrix (of size Nunknowns) and BB contains Nunknowns additional 0s

 For overdetermined food web problems, for instance, the inverse equations may be split up 
 in the mass balance equations which have to be exactly met and the other equations which have to be approximated. 
 \cr This is, it is assumed that the first *NComponents* equations, the mass balances, should be met exactly and the call to the 
 function is: \code{Lsei(lim,exact = 1:lim$NComponents,...)}

 If the food web is underdetermined, an alternative is to use \code{\link{Ldei}} instead. 
 \cr This will return the parsimonious food web. 
 \cr The results should be similar with \code{Lsei(...,parsimonious=TRUE)}. 
In theory both \code{Lsei.lim} and \code{Ldei} should return the same value for underdetermined systems.
}
\seealso{\code{\link[limSolve]{lsei}}, the more general function from package limSolve
\item \code{\link{Linp}}, to solve the linear inverse problem by linear programming 
\item \code{\link{Ldei}}, to solve the linear inverse problem by least distance programming
\item function \code{\link[limSolve]{lsei}} from package\code{limSolve}}
\keyword{algebra}
\keyword{array}
\keyword{optimize}

