% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GICLcusumchart2.R
\name{plot_GICCL_chart2}
\alias{plot_GICCL_chart2}
\title{CUSUM Control Chart with Cautious Learning and Guaranteed Performance}
\usage{
plot_GICCL_chart2(
  alpha,
  beta,
  beta_ratio_plus,
  beta_ratio_minus,
  H_delta_plus,
  H_plus,
  H_delta_minus,
  H_minus,
  known_alpha,
  k_l,
  delay,
  tau,
  n_I,
  n_II,
  faseI = NULL,
  faseII = NULL
)
}
\arguments{
\item{alpha}{Shape parameter of the Gamma distribution (if \code{known_alpha = TRUE}).}

\item{beta}{Scale parameter of the Gamma distribution.}

\item{beta_ratio_plus}{Ratio between \code{beta} and its estimate for upward detection.}

\item{beta_ratio_minus}{Ratio between \code{beta} and its estimate for downward detection.}

\item{H_delta_plus}{Increment of the upper control limit.}

\item{H_plus}{Initial upper limit of the CUSUM chart.}

\item{H_delta_minus}{Increment of the lower control limit.}

\item{H_minus}{Initial lower limit of the CUSUM chart.}

\item{known_alpha}{Indicates whether \code{alpha} is known (\code{TRUE}) or should be estimated (\code{FALSE}).}

\item{k_l}{Secondary control threshold used in the learning logic.}

\item{delay}{Number of observations before updating \code{beta0_est}, \code{H_plus_c}, and \code{H_minus_c}.}

\item{tau}{Time point at which the \code{beta} parameter changes.}

\item{n_I}{Sample size in Phase I (if \code{faseI} is not provided).}

\item{n_II}{Sample size in Phase II (if \code{faseII} is not provided).}

\item{faseI}{Data sample from Phase I (numeric vector). If \code{NULL}, it is generated internally.}

\item{faseII}{Data sample from Phase II (numeric vector). If \code{NULL}, it is generated internally.}
}
\value{
A plot showing the evolution of the CUSUM statistic with cautious learning, including:
\itemize{
\item Dynamically adjusted accumulated values of the CUSUM statistic.
\item Progressively updated control limits with guaranteed performance.
\item A summary of the parameters used in the control chart.
}
}
\description{
This function generates a bidirectional (upward and downward) CUSUM control chart for a Gamma distribution,
incorporating a cautious parameter update mechanism with guaranteed performance. Its purpose is to enhance sensitivity
and precision in detecting changes in dynamic processes.

Based on the methodology presented by Madrid-Alvarez, García-Díaz, and Tercero-Gómez (2024), this implementation allows
control limits to adapt according to the evolution of the process, ensuring early detection of variations while minimizing
the risk of false alarms.
\subsection{Features:}{
\itemize{
\item If the user does not provide Phase I and Phase II data, the function automatically generates them.
\item If \code{known_alpha = TRUE}, \code{alpha} is fixed and not estimated.
\item If \code{known_alpha = FALSE}, \code{alpha} is estimated from Phase I data.
\item Includes dynamic control limits and a summary table of parameters.
\item Enables the detection of both upward and downward deviations, progressively adjusting the control limits.
}
}

\subsection{\strong{Recommendations}}{
\itemize{
\item The parameters \code{k_l}, \code{delay}, and \code{tau} are crucial for the learning process in the control chart.
They regulate the progressive update of control limits, allowing the dynamic update of \code{beta0_est}, \code{H_plus_c}, and \code{H_minus_c}, ensuring that the control chart
gradually adjusts to changes in the process. It is recommended to use reference values presented in:

\strong{Madrid-Alvarez, H. M., García-Díaz, J. C., & Tercero-Gómez, V. G. (2024).}
\emph{A CUSUM control chart for the Gamma distribution with cautious parameter learning.}
Quality Engineering, 1-23.
\item Similar to the parameters above, for proper selection of \code{H_plus}, \code{H_minus}, \code{H_delta_plus}, and \code{H_delta_minus} values,
it is recommended to review the reference article, where detailed calibration strategies for different scenarios are presented.
}
}
}
\examples{
# Option 1: Automatically generated data
plot_GICCL_chart2(alpha = 1, beta = 1,
                 beta_ratio_plus = 2, beta_ratio_minus = 0.5,
                 H_delta_plus = 3.0, H_plus = 6.5,
                 H_delta_minus = 2.0, H_minus = -5.0,
                 known_alpha = TRUE, k_l = 2, delay = 25, tau = 1,
                 n_I = 200, n_II = 700,
                 faseI = NULL, faseII = NULL)

# Option 2: User-provided data
datos_faseI <- rgamma(n = 200, shape = 1, scale = 1)
datos_faseII <- rgamma(n = 700, shape = 1, scale = 1)
plot_GICCL_chart2(alpha = 1, beta = 1,
                 beta_ratio_plus = 2, beta_ratio_minus = 0.5,
                 H_delta_plus = 3.0, H_plus = 6.5,
                 H_delta_minus = 2.0, H_minus = -5.0,
                 known_alpha = FALSE, k_l = 2, delay = 25, tau = 1,
                 n_I = 200, n_II = 700,
                 faseI = datos_faseI, faseII = datos_faseII)

}
