\name{LEAPFrOG_plot}
\alias{LEAPFrOG_plot}
\title{LEAPFrOG plotting function }
\description{Plots offspring and parental admiture proportions in the style of  STRUCTURE, the popular population genetic software.}
\usage{
LEAPFrOG_plot(Results,PopNames,SampNames=NULL)
}
\arguments{
\item{Results}{Array of dimensions 3*Npopulations*Noffspring. The first row is for the genotyped offspring and the second two for the unobserved parents. Each cell contains an admixture proportion.}
\item{PopNames}{Character vector of length J (number of reference populations), Eg. c("Africa","Asia","Europe"). Order of names should correspond with order of parameters in Results.}
\item{SampNames}{Character vector of sample names, equal to number of rows in Results, or NULL (detault), which will be printed underneath the admixture bars. Most useful when dealing with a small number of samples with distinct identity e.g. c("Hair","Blood","Door Handle","Ballroom","Lead Piping"). If NULL then no labels are printed beneath the plot (more appropriate for simulations or large population samples)}
}
\author{Daniel Crouch & Michael Weale, Department of Medical and Molecular Genetics, King's College London}
\examples{
#Example with nonsense data -
#10000 random SNP genotypes 
#...and uniform, random allele frequencies from two populations.
library(LEAPFrOG)
#Get LEAPFrOG parameter estimates  for 10 simulated individuals
Results=array(dim=c(3,2,10))
for(i in 1:10){
z1=LEAPFrOG(sample(0:2,10000,replace=TRUE),cbind(runif(10000,0,1),runif(10000,0,1)))
Results[1,,i]=z1$m    #Offspring 
Results[2,,i]=z1$P1 #Parent 'A'
Results[3,,i]=z1$P2 #Parent 'B
}
#Now plot these 10 individuals
LEAPFrOG_plot(Results,PopNames=c("PopA","PopB"))
#With sample names:
names=c("Hair","Blood","Door Handle","Ballroom","Lead Piping")
names=c(names,"Briefcase","Toothbrush","Sock","Shirt","Skin")
LEAPFrOG_plot(Results,PopNames=c("PopA","PopB"),SampNames=names)
}
\seealso{\code{\link[LEAPFrOG:LEAPFrOG]{LEAPFrOG}},\code{\link[LEAPFrOG:LEAPFrOG_EM]{LEAPFrOG_EM}},\code{\link[LEAPFrOG:BEAPFrOG]{BEAPFrOG}}
}
