% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TS_on_LDA.R
\name{print.TS_on_LDA}
\alias{print.TS_on_LDA}
\title{Print a set of Time Series models fit to LDAs}
\usage{
\method{print}{TS_on_LDA}(x, ...)
}
\arguments{
\item{x}{Class \code{TS_on_LDA} object to be printed.}

\item{...}{Not used, simply included to maintain method compatibility.}
}
\value{
\code{character} \code{vector} of the names of \code{x}'s models.
}
\description{
Convenience function to print only the names of a 
  \code{TS_on_LDA}-class object generated by \code{\link{TS_on_LDA}}.
}
\examples{
\donttest{
  data(rodents)
  document_term_table <- rodents$document_term_table
  document_covariate_table <- rodents$document_covariate_table
  LDAs <- LDA_set(document_term_table, topics = 2:3, nseeds = 2)
  LDA_models <- select_LDA(LDAs)
  weights <- document_weights(document_term_table)
  formulas <- c(~ 1, ~ newmoon)
  mods <- TS_on_LDA(LDA_models, document_covariate_table, formulas,
                    nchangepoints = 0:1, timename = "newmoon", weights)
  print(mods)
}

}
