% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDA_TS_plots.R
\name{plot.LDA_TS}
\alias{plot.LDA_TS}
\title{Plot the key results from a full LDATS analysis}
\usage{
\method{plot}{LDA_TS}(x, ..., cols = set_LDA_TS_plot_cols(),
  bin_width = 1, xname = NULL, border = NA, selection = "median")
}
\arguments{
\item{x}{A \code{LDA_TS} object of a full LDATS model fit by
\code{\link{LDA_TS}}.}

\item{...}{Additional arguments to be passed to subfunctions. Not currently
used, just retained for alignment with \code{plot}.}

\item{cols}{\code{list} of elements used to define the colors for the two
panels of the summary plot, as generated simply using
\code{\link{set_LDA_TS_plot_cols}}. \code{cols} has two elements:
\code{LDA} and \code{TS}, each corresponding the set of plots for
its stage in the full model. \code{LDA} contains entries \code{cols}
and \code{option} (see \code{\link{set_LDA_plot_colors}}). \code{TS}
contains two entries, \code{rho} and \code{gamma}, each corresponding
to the related panel, and each containing default values for entries
named \code{cols}, \code{option}, and \code{alpha} (see
\code{\link{set_TS_summary_plot_cols}}, \code{\link{set_gamma_colors}},
and \code{\link{set_rho_hist_colors}}).}

\item{bin_width}{Width of the bins used in the histograms of the summary
time series plot, in units of the time variable used to fit the model
(the x-axis).}

\item{xname}{Label for the x-axis in the summary time series plot. Defaults
to \code{NULL}, which results in usage of the \code{timename} element
of the control list (held in\code{control$TS_control$timename}). To have
no label printed, set \code{xname = ""}.}

\item{border}{Border for the histogram, default is \code{NA}.}

\item{selection}{Indicator of the change points to use in the time series
summary plot. Currently only defined for \code{"median"} and
\code{"mode"}.}
}
\value{
\code{NULL}.
}
\description{
Generalization of the \code{\link[graphics]{plot}} function to
  work on fitted LDA_TS model objects (class \code{LDA_TS}) returned by
  \code{\link{LDA_TS}}).
}
\examples{
\donttest{
  data(rodents)
  mod <- LDA_TS(data = rodents, topics = 2, nseeds = 1, formulas = ~1,
                nchangepoints = 1, timename = "newmoon")
  plot(mod, binwidth = 5, xlab = "New moon")
}

}
