% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TS_on_LDA.R
\name{select_TS}
\alias{select_TS}
\title{Select the best Time Series model}
\usage{
select_TS(TS_models, control = list())
}
\arguments{
\item{TS_models}{An object of class \code{TS_on_LDA} produced by
\code{\link{TS_on_LDA}}.}

\item{control}{A \code{list} of parameters to control the fitting of the
Time Series model including the parallel tempering Markov Chain 
Monte Carlo (ptMCMC) controls. Values not input assume defaults set by 
\code{\link{TS_control}}.}
}
\value{
A reduced version of \code{TS_models} that only includes the 
  selected TS model. The returned object is a single TS model object of
  class \code{TS_fit}.
}
\description{
Select the best model of interest from an
  \code{TS_on_LDA} object generated by \code{\link{TS_on_LDA}}, based on
  a set of user-provided functions. The functions default to choosing the 
  model with the lowest AIC value. \cr \cr
  Presently, the set of functions should result in a singular selected
  model. If multiple models are chosen via the selection, only the first
  is returned.
}
\examples{
\donttest{
  data(rodents)
  document_term_table <- rodents$document_term_table
  document_covariate_table <- rodents$document_covariate_table
  LDAs <- LDA_set(document_term_table, topics = 2:3, nseeds = 2)
  LDA_models <- select_LDA(LDAs)
  weights <- document_weights(document_term_table)
  formulas <- c(~ 1, ~ newmoon)
  mods <- TS_on_LDA(LDA_models, document_covariate_table, formulas,
                    nchangepoints = 0:1, timename = "newmoon", weights)
  select_TS(mods)
}

}
