% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LAR_summary.R
\name{LAR_summary}
\alias{LAR_summary}
\title{Get a summary of LAR}
\usage{
LAR_summary(
  data,
  excel = FALSE,
  filename = NULL,
  weight_site = "no",
  weight_value = 0,
  current = as.numeric(substr(Sys.time(), 1, 4)),
  sim = 300,
  seed = 99,
  basepy = 1e+05,
  DDREF = TRUE,
  ci = 0.9,
  changedata = FALSE,
  dbaseline = 0,
  dincidence = 0,
  rounddigit = 4
)
}
\arguments{
\item{data}{data frame containing 'id', 'sex', 'birth', 'dosedist', 'dose1', 'dose2', 'dose3', 'site', 'exposure_rate'.}

\item{excel}{logical. Whether to extract the result as csv file.}

\item{filename}{a string naming the file to save (.csv file).}

\item{weight_site}{vector containing the name of cancer sites to give weights.}

\item{weight_value}{numeric vector containing the value between 0 and 1 which is a weight on ERR model.}

\item{current}{number of current year. default is year of the system time.}

\item{sim}{number of iteration of simulation.}

\item{seed}{number of seed.}

\item{basepy}{number of base person year}

\item{DDREF}{logical. Whether to apply the dose and dose-rate effectiveness factor.}

\item{ci}{confidence level of the confidence interval.}

\item{changedata}{logical, whether to change the data of lifetime table and incidence rate.}

\item{dbaseline}{a path or data frame of the new lifetime table.}

\item{dincidence}{a path or data frame of the new incidence rate table.}

\item{rounddigit}{the number of decimal points to print.}
}
\value{
\code{LAR_summary} return a list of values. These values are a summary of LAR.

\code{LAR}

Cancer incidence probability per 100,000 persons to radiation exposure for their lifetime after exposed  year.

\code{LBR}

Lifetime baseline risk. Cumulative baseline probability of having cancer over the maximum lifetime without radiation exposure after  exposed year.

\code{LFR}

Lifetime fractional risk. Ratio LAR/LBR.

\code{Future_LAR}

LAR after current year.

\code{BFR}

Baseline future risk. Cumulative baseline probability of having cancer over the maximum lifetime without radiation exposure after  current year.

\code{TFR}

Total future risk. Future LAR + BFR
}
\description{
\code{LAR_summary} provides a summary of lifetime attributable radiation-related cancer risk.
}
\details{
Basically, the arguments of \code{LAR_batch} are same as \code{LAR}.
}
\examples{
data<-data.frame(id=c("a100","a101"), birth=rep(1970,2), exposure=c(1980,1990),
                 dosedist=c("fixedvalue","fixedvalue"), dose1=c(10,20), dose2=c(0,0),
                 dose3=c(0,0), sex=rep("male",2), site=c("colon","leukemia"),
                 exposure_rate=rep("acute",2))

LAR_summary(data)

}
\references{
Berrington de Gonzalez, A., Iulian Apostoaei, A., Veiga, L., Rajaraman, P., Thomas, B., Owen Hoffman, F., Gilbert, E. and Land, C. (2012). RadRAT: a radiation risk assessment tool for lifetime cancer risk projection. \emph{Journal of Radiological Protection}, \bold{32(3)}, pp.205-222.

National Research Council (NRC) and Committee to Assess Health Risks from Exposure to Low Levels of Ionizing Radiation (2005) \emph{Health Risks from Exposure to Low Levels of Ionizing Radiation: BEIR VII Phase 2} (Washington, DC: National Academy of Sciences)
}
