% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.R
\name{lagosne_select}
\alias{lagosne_select}
\title{Select and filter LAGOSNE data}
\usage{
lagosne_select(
  table = NULL,
  vars = NULL,
  categories = NULL,
  dt = lagosne_load(lagosne_version())
)
}
\arguments{
\item{table}{character name of a dt table}

\item{vars}{character vector of specific column names to select from table}

\item{categories}{what type of variables should be kept. Note not all scale-category options are available. Variable categories include:
\itemize{
    \item "waterquality" - includes all in-situ chemistry, chlorophyll, and water clarity measurements from the epi_nutr table.
    \item "deposition" - all atmospheric deposition variables from the .chag tables
    \item "hydrology" - baseflow, groundwater, runoff, and overland flow variables from the .chag tables
    \item "climate" - 30-year normal precipitation and temperature variables from the .chag tables
    \item "geology" - all surficial geology variables from the .chag tables
    \item "topography" - Terrain Roughness Index and slope variables from the .lulc tables
    \item "lulc1992" - all 1992 land use/land cover variables from the .lulc tables
    \item "lulc2001" - all 2001 land use/land cover variables from the .lulc tables
    \item "lulc2006" - all 2006 land use/land cover variables from the .lulc tables
    \item "lulc2011" - all 2011 land use/land cover variables from the .lulc tables
    \item "lakes" - all lake connectivity metrics from the .conn tables
    \item "wetlands" - all wetland connectivity metrics from the .conn tables
    \item "streams" - all stream/river connectivity metrics from the .conn tables
}}

\item{dt}{data.frame of local copy of LAGOSNE data.  Can be loaded with \code{\link{lagosne_load}} and will use version as specified in \code{\link{lagosne_version}}.}
}
\description{
Select and filter LAGOSNE data with keyword helpers.
}
\examples{
\dontrun{
dt <- lagosne_load("1.087.3")

# specific variables
head(lagosne_select(table = "epi_nutr", vars = c("tp", "tn")))
head(lagosne_select(table = "iws.lulc", vars = c("iws_nlcd2011_pct_95")))

# categories
head(lagosne_select(table = "epi_nutr", categories = "waterquality"))
head(lagosne_select(table = "county.chag", categories = "hydrology"))
head(lagosne_select(table = "hu4.chag", categories = "deposition"))

# mix of specific variables and categories
head(lagosne_select(table = "epi_nutr", vars = "lagoslakeid", categories = c("waterquality")))

}
}
