% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LAGOSNE-package.R
\docType{data}
\name{lulc}
\alias{lulc}
\alias{buffer100m.lulc}
\alias{buffer500m.lulc}
\alias{iws.lulc}
\alias{hu12.lulc}
\alias{hu8.lulc}
\alias{hu4.lulc}
\alias{edu.lulc}
\alias{county.lulc}
\alias{state.lulc}
\alias{topography}
\alias{nlcd}
\title{Land Use Land Cover (LULC) Data Frames}
\format{Data frames with all or a subset of the following variables. Number
of observations is equal to the number of zones in each spatial scale
(see Details below). Wildcard options include the 9 LAGOSNE spatial scales
(* = buffer100m, buffer500m, iws, hu12, hu8, hu4, edu,
county, state), year of measurement (** = 1992, 2001, 2006, 2011), and unit
of measurement in hectares or percent of zone area (*** = ha, pct unless
noted otherwise). Each variable is available at each scale, year, and unit
unless otherwise noted.
\itemize{
   \item *_nhdid (* = buffer100m, buffer500m, iws)
   \item *_canopy2001_***: per pixel tree canopy percent measured 2001.
    Summary statistics include minimum, maximum, mean and standard deviation
    (*** = min, max, mean, std).
   \item *_damdensity_***: dams in zone. Summary statistics include a point
   count, points per hectare, and points per square kilometer
   (*** = pointcount, pointsperha, pointspersqkm)
   \item *_nlcd**_***_0: No data
   \item *_nlcd**_***_11: Open water
   \item *_nlcd1992_***_21: Residential, low intensity
   \item *_nlcd**_***_21: Developed, open space. Note, this variable was
   not measured in 1992 (** = 2001, 2006, 2011)
   \item *_nlcd1992_***_22: Residential, high intensity
   \item *_nlcd**_***_22: Developed, low intensity. Note, this variable was
   not measured in 1992 (** = 2001, 2006, 2011)
   \item *_nlcd1992_***_23: Commercial/industrial/transportation
   \item *_nlcd**_***_23: Developed, medium intensity. Note, this variable was
   not measured in 1992 (** = 2001, 2006, 2011)
   \item *_nlcd**_***_24: Developed, high Intensity. Note, this variable was
   not measured in 1992 (** = 2001, 2006, 2011)
   \item *_nlcd**_***_31: Bare rock/sand/clay
   \item *_nlcd1992_***_32: Quarries/strip mines/gravel pits measured in
   1992
   \item *_nlcd1992_***_33: Transitional (barren) measured in 1992
   \item *_nlcd**_***_41: Deciduous forest
   \item *_nlcd**_***_42: Evergreen forest
   \item *_nlcd**_***_43: Mixed forest
   \item *_nlcd1992_***_51: Shrubland measured in 1992.
   \item *_nlcd1992_***_52: Scrub/shrub. Note, this variable not measured in
   1992
   (** = 2001, 2006, 2011)
   \item *_nlcd1992_***_61: Orchards/vineyards/other measured in 1992.
   \item *_nlcd**_***_71: Grasslands/herbaceous
   \item *_nlcd**_***_81: Pasture/hay
   \item *_nlcd**_***_82: Row crops
   \item *_nlcd1992_***_83: Small grains measured in 1992.
   \item *_nlcd1992_***_85: Urban/recreational grasses measured in 1992.
   \item *_nlcd**_***_90: Woody wetlands. Note, this variable not calculated
    in 1992
   (** = 2001, 2006, 2011). Equivalent code for 1992 = 91.
   \item *_nlcd1992_***_91: Woody wetlands measured in 1992. Equivalent code
   for 2001, 2006 and 2011 = 90.
   \item *_nlcd1992_***_92: Emergent herbaceous wetlands measured in 1992.
   Equivalent code for 2001, 2006, and 2011 = 95.
   \item *_nlcd**_***_95: Emergent herbaceous wetlands. Note, this variable
   not calculated in 1992 (** = 2001, 2006, 2011). Equivalent code for
   1992 = 92.
   \item *_roaddensity_***: Roads within the zone, calculated as sum of the
   length in meters, or sum of the length in meters divided by area of zone
   in hectares (*** = sum_lengthm, density_mperha)
   \item *_slope_***: The slope at each cell is the slope with respect to
   its immediate neighbors (10m scale). Cells in zone summarized as either
   the minimum, maximum, mean, or standard deviation (*** = min, max,
   mean, std)
   \item *_tri_***: Terrain ruggedness index (TRI) at each cell is the
   absolute difference in meters between the elevation of the focal cell and
   its immediate neighbors (10m scale).
   Cells in zone summarized as either the minimum, maximum, mean,
   or standard deviation (*** = min, max, mean, std)
   \item *_zoneid: unique zone identifier (* = iws, hu12, hu8, hu4, edu,
   county, state)
   \item lagoslakeid: unique integer identifier for focal lake
   \item lakeconnection: connectivity class of focal lake. Only in iws.lulc
   table.
   \item borderiws: whether iws zone intersects Canadian border
   (1 = yes, NA = no). Only in iws.lulc table.
    }}
\description{
Datasets containing information on the land use and land cover (LULC)
characteristics calculated at all LAGOSNE spatial classifications
(see ?scales) from the National Land Cover Dataset (NLCD).
}
\details{
Original data sources and layers from which each metric was derived can be
found in additional file 5 of Soranno et al. (2015).
}
\references{
Soranno et al. (2017) \href{https://doi.org/10.1093/gigascience/gix101}{Gigascience 6:12};
}
\keyword{datasets}
