% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/L1centNB.R
\name{L1centNB}
\alias{L1centNB}
\alias{L1centNB.igraph}
\alias{L1centNB.matrix}
\title{L1 Centrality-Based Neighborhood}
\usage{
L1centNB(g, eta)

\method{L1centNB}{igraph}(g, eta = NULL)

\method{L1centNB}{matrix}(g, eta = NULL)
}
\arguments{
\item{g}{An \code{igraph} graph object or a distance matrix. The graph must
be undirected and connected. Equivalently, the distance matrix must be
symmetric, and all entries must be finite.}

\item{eta}{An optional nonnegative multiplicity (weight) vector for (vertex)
weighted networks. The sum of its components must be positive. If set to
\code{NULL} (the default), all vertices will have the same positive weight
(multiplicity), i.e., \code{g} is treated as a vertex unweighted graph. The
length of the \code{eta} must be equivalent to the number of vertices.}
}
\value{
A list of numeric vectors. The length of the list is
equivalent to the number of vertices in the graph \code{g}, and the names of the
list are vertex names. Each component of the list is a numeric vector whose
length is equivalent to the number of vertices in the graph \code{g}.
Specifically, the \code{i}th component of the list is a vector of the
\ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}} centrality of each
vertex, for the symmetrized graph \code{g} w.r.t. the \code{i}th vertex.
}
\description{
Derives \ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}}
centrality-based neighborhood of each vertex.
}
\details{
If a graph is symmetrized (in a way defined in Kang and Oh (2023))
w.r.t. a vertex \ifelse{html}{\out{<i>v</i>}}{\eqn{v}}, vertex
\ifelse{html}{\out{<i>v</i>}}{\eqn{v}} becomes the graph median (Kang and Oh,
2023), i.e., \ifelse{html}{\out{<i>v</i>}}{\eqn{v}} has
\ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}} centrality 1. Based on
this property, we define the
\ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}} centrality-based
neighborhood of vertex \ifelse{html}{\out{<i>v</i>}}{\eqn{v}} as vertices
that have large \ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}}
centrality on the symmetrized graph w.r.t. vertex
\ifelse{html}{\out{<i>v</i>}}{\eqn{v}}.
}
\note{
The function is valid only for undirected and connected graphs.
}
\examples{
NB <- L1centNB(MCUmovie, eta = igraph::V(MCUmovie)$worldwidegross)
# Top 6 L1 centrality-based neighbors of "Iron Man"
utils::head(sort(NB$"Iron Man", decreasing = TRUE))
}
\references{
S. Kang and H.-S. Oh. On a notion of graph centrality based on
\ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}} data depth.
Technical Report, 2023.
}
\seealso{
\code{\link[=L1cent]{L1cent()}} for
\ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}} centrality,
\code{\link[=L1centLOC]{L1centLOC()}} and \code{\link[=L1centEDGE]{L1centEDGE()}} internally uses \code{L1centNB()}.
}
