/*
 * Decompiled with CFR 0.152.
 */
package kr.pe.freesearch.korean;

import kr.pe.freesearch.korean.KoHangul;
import kr.pe.freesearch.korean.KoHangulAutomata;

public class KoJamoAutomata
extends KoHangulAutomata {
    public KoJamoAutomata(boolean force) {
        super(force);
    }

    @Override
    protected void feed(char ch) {
        this.rawChar.add(Character.valueOf(ch));
        if (KoHangul.isJamo(ch)) {
            if (KoHangul.isJaeum(ch)) {
                if (this.choSung == '\u0000') {
                    if (this.jwungSung != '\u0000' || this.jongSung != '\u0000') {
                        if (this.forceConvert) {
                            this.pushcomp();
                            this.choSung = ch;
                        } else {
                            this.wordValid = 0;
                        }
                    } else {
                        this.choSung = ch;
                    }
                } else if (this.jwungSung == '\u0000') {
                    if (this.jongSung != '\u0000') {
                        this.wordValid = 0;
                    } else {
                        this.pushcomp();
                        this.choSung = ch;
                    }
                } else if (this.jongSung == '\u0000') {
                    if (KoHangul.getJongsungIdx(ch) == -1) {
                        this.pushcomp();
                        this.choSung = ch;
                    } else {
                        this.jongSung = ch;
                    }
                } else {
                    String jong = KoHangul.getKeyfromCode(this.jongSung);
                    int len = jong.length();
                    if (len == 1) {
                        char[] trymul = new char[10];
                        System.arraycopy(jong.toCharArray(), 0, trymul, 0, jong.length());
                        trymul[0] = jong.charAt(0);
                        String jong2nd = KoHangul.getKeyfromCode(ch);
                        System.arraycopy(jong2nd.toCharArray(), 0, trymul, jong.length(), jong2nd.length());
                        String strTrymul = new String(trymul, 0, jong.length() + jong2nd.length());
                        if (KoHangul.isInKeyCode(strTrymul)) {
                            this.jongSung = KoHangul.getCodefromKey(strTrymul);
                        } else {
                            this.pushcomp();
                            this.choSung = ch;
                        }
                    } else if (len == 2) {
                        this.pushcomp();
                        this.choSung = ch;
                    } else assert (false);
                }
            } else if (this.jongSung == '\u0000') {
                if (this.jwungSung == '\u0000') {
                    this.jwungSung = ch;
                } else {
                    char[] trymul = new char[10];
                    String jwung = KoHangul.getKeyfromCode(this.jwungSung);
                    System.arraycopy(jwung.toCharArray(), 0, trymul, 0, jwung.length());
                    String jwung2nd = KoHangul.getKeyfromCode(ch);
                    System.arraycopy(jwung2nd.toCharArray(), 0, trymul, jwung.length(), jwung2nd.length());
                    String strTrymul = new String(trymul, 0, jwung.length() + jwung2nd.length());
                    if (KoHangul.isInKeyCode(strTrymul)) {
                        this.jwungSung = KoHangul.getCodefromKey(strTrymul);
                    } else {
                        this.pushcomp();
                        this.jwungSung = ch;
                    }
                }
            } else {
                String jong = KoHangul.getKeyfromCode(this.jongSung);
                int jongLen = jong.length();
                assert (jongLen > 0 && jongLen < 3);
                if (jongLen > 1) {
                    char[] strF = new char[]{jong.charAt(0)};
                    char ojong = KoHangul.getCodefromKey(new String(strF, 0, 1));
                    char[] strS = new char[]{jong.charAt(1)};
                    char ncho = KoHangul.getCodefromKey(new String(strS, 0, 1));
                    this.jongSung = ojong;
                    this.pushcomp();
                    this.choSung = ncho;
                    this.jwungSung = ch;
                } else {
                    char njong = this.jongSung;
                    this.jongSung = '\u0000';
                    this.pushcomp();
                    this.choSung = njong;
                    this.jwungSung = ch;
                }
            }
        } else {
            int isUncompleted = this.finalization();
            if (isUncompleted == 0 || isUncompleted == 2) {
                this.HangulBuffer.add(Character.valueOf(ch));
            }
        }
    }

    public static void main(String[] args) {
        KoJamoAutomata am = new KoJamoAutomata(false);
        System.out.println(am.convert("\u3148\u3153\u3134\u314e\u3161\u3163\u3147\u315c\u3153\u3134"));
        am.clear();
        System.out.println(am.convert("\u3147\u314f\u3139\u3141"));
        am.clear();
        System.out.println(am.convert("sksms wjdakf glaemfdj"));
    }
}

