\name{KnowBPolygon}
\alias{KnowBPolygon}
\title{Discriminating well surveyed polygon units from exhaustive biodiversity databases}
\description{It is the same function than \link[KnowBR]{KnowB} but the estimation of the well surveyed units is on polygons instead of on cells.}
\usage{
KnowBPolygon(data, format="A", shape=NULL, shapenames=NULL, admAreas=FALSE,
Area="World", curve="Rational", estimator=1, cutoff=1, cutoffCompleteness=0,
cutoffSlope=1, extent=TRUE, minLon, maxLon, minLat, maxLat, int=30, colbg="#FFFFFF",
colcon="#C8C8C8", colf="black", pro = TRUE, inc=0.005, exclude=NULL, colexc=NULL,
colfexc="black", colscale=c("#C8FFFFFF","#64FFFFFF",
"#00FFFFFF","#64FF64FF","#C8FF00FF","#FFFF00FF","#FFC800FF","#FF6400FF","#FF0000FF"),
legend.pos="y", breaks=9, xl=0, xr=0, yb=0, yt=0, asp, lab=NULL,
xlab="Longitude", ylab="Latitude", main1="Records", main2="Observed richness",
main3="Completeness", main4="Slope", cex.main=1.6, cex.lab=1.4, cex.axis=1.2,
cex.legend=0.9, family="sans", font.main=2, font.lab=1, font.axis=1,
lwdP=0.6, lwdC=0.1, trans=c(1,1), ndigits=0, save="CSV", file1="Species per site",
file2="Estimators", file3="Standard error of the estimators", na="NA",
dec=",", row.names=FALSE, Maps=TRUE, jpg=TRUE, jpg1="Records.jpg",
jpg2="Observed richness.jpg",  jpg3="Completeness.jpg", jpg4="Slope.jpg",
cex=1.5, pch=15,cex.labels=1.5, pchcol="red", ask=FALSE)
}
\arguments{
  \item{data}{The data is introduced as a CSV, TXT or RData file following two simple formats (for further details see the description of the same argument in the function \link[KnowBR]{KnowB}.): one in which only four columns are included (format A; species name, longitude, latitude and a number reflecting the incidence of the species) and another one including the longitude and latitude of each spatial unit and as many columns as species (format B). The CSV file with the format A may be obtained using ModestR (see details).}
  \item{format}{If it is "A" (default), the format of the data frame is species, longitude, latitude and a count value. If it is "B" the format of the data frame is longitude, latitude and the rest of columns are the presence of the species in each site (for further details see the description of the same argument in the function \link[KnowBR]{KnowB}).}
    \item{shape}{Optionally it may be used a shape file with the information of the polygons.}
  \item{shapenames}{Variable in the shapefile with the names of the polygons.}
  \item{admAreas}{If it is TRUE the border lines of the countries are depicted in the map.}
  \item{Area}{A character with the name of the administrative area or a vector with several administrative areas (see details). If a vector with several administrative areas are used, it is necessary to use RWizard (see details section in the function \link[KnowBR]{KnowB}).}
  \item{curve}{The smoothed accumulation curve generated by the accumulation curve can be adjusted to a "Clench", "Exponential", "Saturation" or "Rational" function (see equations in details section of function \link[KnowBR]{KnowB}), calculating the asymptotic extrapolated values to further derive a completeness percentage (the percentage representing the observed number of species against the predicted one).}
  \item{estimator}{Vector that defines the used estimator (see the same argument in the function \link[KnowBR]{KnowB}).}
  \item{cutoff}{This number reflects the ratio between the number of database records and the number of species. If this ratio is lower than the selected threshold value in each considered spatial unit, any one of the estimators will be calculated and these spatial units are considered as lacking information.}
  \item{cutoffCompleteness}{If the value of completeness is lower than this threshold, the completeness is not calculated.}
  \item{cutoffSlope}{If the slope is higher than this threshold, the completeness is not calculated.}
  \item{extent}{If TRUE the minimum and maximum longitudes and latitudes are delimited by the minimum and maximum of the data (default). If FALSE the minimum and maximum longitudes and latitudes are delimited by the arguments Area and, minLat, maxLat, minLon and maxLon.}
  \item{minLon, maxLon}{Optionally it is possible to define the minimum and maximum longitude (see details).}
  \item{minLat, maxLat}{Optionally it is possible to define the minimum and maximum latitude (see details).}
\item{int}{Number of intervals of the color ramp.}
  \item{colbg}{Background color of the map (in some cases this is the sea).}
  \item{colcon}{Background color of the administrative areas.}
  \item{colf}{Color of administrative areas border.}
  \item{pro}{If it is TRUE an automatic calculation is made in order to correct the spect ratio y/x along latitude.}
  \item{inc}{Adds some room along the map margins with the limits x and y thus not exactly the limits of the selected areas.}
  \item{exclude}{A character with the name of the administrative area or a vector with several administrative areas that can be plotted with a different color on the map.}
  \item{colexc}{Background color of areas selected in the argument exclude.}
  \item{colfexc}{Color of borders of the areas selected in the argument exclude.}
  \item{colscale}{Palette color.}
  \item{legend.pos}{Whether to have a horizontal (x) or vertical (y) color gradient.}
  \item{breaks}{Number of breakpoints of the color legend.}
  \item{xl,xr,yb,yt}{The lower left and upper right coordinates of the color legend in user coordinates.}
  \item{asp}{The y/x aspect ratio.}
  \item{lab}{A numerical vector of the form c(x. Y) which modified the default method by which axes are annotated. The values of x and y give the (approximate) number of tick marks on the x and y axes.}
  \item{xlab}{A title for the x axis.}
  \item{ylab}{A title for the y axis.}
  \item{main1}{An overall title for the plot of the observed species richness.}
  \item{main2}{An overall title for the plot of the records.}
  \item{main3}{An overall title for the plot of the completeness.}
  \item{main4}{An overall title for the plot of the slope between the last species richness value and the previous value for each one of the accumulation methods.}
  \item{cex.main}{The magnification to be used for main titles relative to the current setting of cex.}
  \item{cex.lab}{The magnification to be used for x and y labels relative to the current setting of cex.}
  \item{cex.axis}{The magnification to be used for axis annotation relative to the current setting of cex.}
  \item{cex.legend}{The magnification to be used in the numbers of the color legend relative to the current setting of cex.}
  \item{family}{The name of a font family for drawing text.}
  \item{font.main}{The font to be used for plot main titles.}
  \item{font.lab}{The font to be used for x and y labels.}
  \item{font.axis}{The font to be used for axis annotation.}
  \item{lwdP}{Line width of the plot.}
  \item{lwdC}{Line width of the borders.}
  \item{trans}{It is possible to multiply or divide the dataset by a value. For a vector with two values, the first may be 0 (divide) or 1 (multiply), and the second number is the value of the division or multiplication.}
  \item{ndigits}{Number of decimals in legend of the color scale.}
  \item{save}{If "CSV" the files are save as CSV and if "RData" the files are save as RData.}
  \item{file1}{RData or CSV file. A character string naming the file with the species or CSV per site.}
  \item{file2}{RData file or CSV file. A character string naming the file with the estimators per shape.}
  \item{file3}{RData or CSV file. A character string naming the file with the standard error of the estimators.}
  \item{na}{CSV FILE. Text that is used in the cells without data.}
  \item{dec}{CSV FILE. It defines if the comma "," is used as decimal separator or the dot ".".}
  \item{row.names}{CSV FILE. Logical value that defines if identifiers are put in rows or a vector with a text for each of the rows.}
  \item{Maps}{If it is TRUE the maps are depicted.}
  \item{jpg}{If TRUE the plots are exported to jpg files instead of using the windows device.}
  \item{jpg1}{Name of the jpg file with the records.}
  \item{jpg2}{Name of the jpg file with of the values of observed richness.}
  \item{jpg3}{Name of the jpg file with the completeness.}
  \item{jpg4}{Name of the jpg file with the slopes of the accumulation analyses.}
  \item{cex}{A numerical value giving the amount by which plotting symbols should be magnified relative to the default in the correlation matrix plot.}
  \item{pch}{Either an integer specifying a symbol or a single character to be used as the default in plotting points in the correlation matrix plot.}
  \item{cex.labels}{Size of labels in the correlation matrix plot.}
  \item{pchcol}{Color of the symbols in the correlation matrix plot.}
  \item{ask}{If TRUE (and the R session is interactive) the user is asked for input before a new figure is drawn.}
}
\details{
\strong{FUNCTIONS}

The estimators exact and random were estimated with the function \link[vegan]{specaccum} of the package vegan (Oksanen \emph{et al}., 2014).

The color legend of the maps is depicted with the function \link[plotrix]{color.legend} of the package plotrix (Lemon et al., 2014).

The polygons are depicted with the function \link[sp]{spplot} of the package sp (Edzer \emph{et al}. 2005; Bivand \emph{et al}., 2013; Pebesma \emph{et al}. 2017).

\strong{EXAMPLE}

\strong{Example 1.} The database of the example includes 15,142 records for the 54 Iberian species of the Scarabaeidae (Coleoptera) previously compiled in the so called BANDASCA database (Lobo & Martn-Piera, 2002). The following maps show the records obtained in provinces of Spain using the estimator exact and the Rational function to adjust the data. 
\tabular{c}{
\if{html}{\figure{F3.jpg}{options: width="50"}}
\if{latex}{\figure{F3.jpg}{options: width=5.0in}}
\cr
}
\strong{Example 2.} An example using an external shape uploaded by the user (in this case the states of USA). The dataset are the records downloaded from GBIF of the flowering plants of the family Polygonaceae.The states with a grey background had no records, species and/or it was not possible to estimate the slope and/or completeness.
\tabular{c}{
\if{html}{\figure{F4.jpg}{options: width="50"}}
\if{latex}{\figure{F4.jpg}{options: width=4.5in}}

\cr
}

}
\value{
The folowing files are obtained:

RData or CSV files: 1) Species per site, 2) Estimators and 3) Standard error and R2 of the functions.

JPG files with maps: 1)Records, 2) Observed richness, 3) Completeness and 4) Slope.
}
\source{Spatial database of the location of the world's administrative areas (or administrative boundaries) was obtained from the Web Site http://www.openstreet.org/.}
\references{
Bivand, R.S., Pebesma, E. & Gomez-Rubio, V. 2013. \emph{Applied spatial data analysis with R}. Springer, NY.

Edzer J. Pebesma, E.J. & Bivand, R.S. 2005. Classes and methods for spatial data in R. \emph{R News}, 5: 9-13.

Lobo, J.M. & Martn-Piera, F. 2002. Searching for a predictive model for Iberian dung beetle species richness based on spatial and environmental variables. \emph{Conservation Biology}, 16: 158-173.

Miller, R.I. & Wiegert, R.G. (1989) Documenting completeness species-area relations, and the species-abundance distribution of a regional flora. \emph{Ecology}, 70: 16-22.

Monod, J. (1950) La technique de culture continue, thorie et applications. \emph{ Annales de l'Institut Pasteur (Paris)},  79: 390-410.

Oksanen, J., Blanchet, F.G., Kindt, R., Legendre, P., Minchin, P.R., O'Hara, R.B., Simpson, G.L., Solymos, P., Henry, M., Stevens, H. & Wagner, H. 2014. Community Ecology Package. R package version 2.0-10. Available at: https://CRAN.R-project.org/package=vegan.

Pebesma, E., Bivand, R.S., Rowlingson, B., Gomez-Rubio, V., Hijmans, R., Sumner, M., MacQueen, D., Lemon, J. & O'Brien, J. 2017. Classes and Methods for Spatial Data. R package version 1.2-5. Available at: http://CRAN.R-project.org/package=sp.

Sobern, J. & Llorente, B.J. 1993. The use of species accumulation functions for the prediction of species richness. \emph{Conservation Biology}, 7: 480-488.
}
\examples{

\dontrun{

#Example 1. Only to be used with RWizard

data(Beetles)
@_Build_AdWorld_
KnowBPolygon(data = Beetles , Area = c("Andaluca>Almera", "Andaluca>Cdiz",
"Andaluca>Crdoba", "Andaluca>Granada", "Andaluca>Huelva", "Andaluca>Jan",
"Andaluca>Mlaga", "Andaluca>Sevilla", "Aragn>Huesca", "Aragn>Teruel",
"Aragn>Zaragoza", "Cantabria>Cantabria", "Castilla y Len>vila", "Castilla y Len>Burgos",
"Castilla y Len>Len", "Castilla y Len>Palencia", "Castilla y Len>Salamanca",
"Castilla y Len>Segovia", "Castilla y Len>Soria", "Castilla y Len>Valladolid",
"Castilla y Len>Zamora", "Castilla-La Mancha>Albacete", "Castilla-La Mancha>Ciudad Real",
"Castilla-La Mancha>Cuenca", "Castilla-La Mancha>Guadalajara", "Castilla-La Mancha>Toledo",
"Catalua>Barcelona", "Catalua>Girona", "Catalua>Lleida", "Catalua>Tarragona",
"Ceuta>Ceuta", "Comunidad de Madrid>Madrid", "Comunidad Foral de Navarra>Navarra",
"Comunidad Valenciana>Alicante", "Comunidad Valenciana>Castelln",
"Comunidad Valenciana>Valencia", "Extremadura>Badajoz", "Extremadura>Cceres",
"Galicia>A Corua", "Galicia>Lugo", "Galicia>Ourense", "Galicia>Pontevedra",
"Islas Baleares>Baleares", "Islas Canarias>Las Palmas", "Islas Canarias>Santa Cruz de Tenerife",
"La Rioja>La Rioja", "Melilla>Melilla", "Pas Vasco>lava", "Pas Vasco>Guipzcoa",
"Pas Vasco>Vizcaya", "Principado de Asturias>Asturias", "Regin de Murcia>Murcia") ,
minLon = -10 , minLat = 35 , admAreas = TRUE , jpg = FALSE)

#Example 2.

#Download records from GBIF of the flowering plants of the family Polygonaceae

library(rgbif)
records<-occ_search(scientificName = "Polygonaceae", limit=5000, return='data',
hasCoordinate=TRUE)

#Data frame with the format A required by the function KnowBPolygon

records<-data.frame(records$species,records$decimalLongitude, records$decimalLatitude)
names(records)<-c("Species","Longitude","Latitude")

#A column is added to the records with the number of counts
#(format A), assuming 1 count per record

dim<-dim(records)
Counts<-rep(1,dim[1])
records<-cbind(records,Counts)

#Running the function

data(States) #State Boundaries of the United States
data(adworld)
KnowBPolygon(data=records, shape=States, admAreas=TRUE, shapenames="NAME", minLon=-130,
maxLon=-70, minLat=25, maxLat=50, colscale=rev(heat.colors(100)), jpg=FALSE)
}
}
\keyword{KnowBPolygon}
