% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{KHQ_Conv_KHQ5D_data}
\alias{KHQ_Conv_KHQ5D_data}
\title{KHQ data to convert to KHQ5D scores}
\format{
This data frame has 30 rows and the following 9 columns:
\describe{
\item{3a}{Role Limitations:
Q - To what extent does your bladder problem affect your household tasks (e.g., cleaning, shopping etc)?
R - 1 = Not at all; 2 = Slightly; 3 = Moderately; 4 = A lot.}
\item{3b}{Role Limitations:
Q - Does your bladder problem affect your job, or your normal daily activities outside the home?
R - 1 = Not at all; 2 = Slightly; 3 = Moderately; 4 = A lot.}
\item{4a}{Physical Limitations:
Q - Does your bladder problem affect your physical activities (e.g., going for a walk, run, sport, gym etc)?
R - 1 = Not at all; 2 = Slightly; 3 = Moderately; 4 = A lot.}
\item{4b}{Physical Limitations:
Q - Does your bladder problem affect your ability to travel?
R - 1 = Not at all; 2 = Slightly; 3 = Moderately; 4 = A lot.}
\item{4d}{Social Limitations:
Q - Does your bladder problem limit your ability to see/visit friends?
R - 1 = Not at all; 2 = Slightly; 3 = Moderately; 4 = A lot.}
\item{5c}{Personal Relationship:
Q - Does your bladder problem affect your family life?
R - 0 = Not applicable; 1 = Not at all; 2 = Slightly; 3 = Moderately; 4 = A lot.}
\item{6a}{Emotions:
Q - Does your bladder problem make you feel depressed?
R - 1 = Not at all; 2 = Slightly; 3 = Moderately; 4 = A lot.}
\item{6b}{Emotions:
Q - Does your bladder problem make you feel anxious or nervous?
R - 1 = Not at all; 2 = Slightly; 3 = Moderately; 4 = A lot.}
\item{7a}{Sleep/Energy:
Q - Does your bladder problem affect your sleep?
R - 1 = Never; 2 = Sometimes; 3 = Often; 4 = Very much.}
}
}
\source{
Example data
}
\usage{
KHQ_Conv_KHQ5D_data
}
\description{
This data set contains an example of 30 responses of the KHQ
items used to convert to KHQ5D scores.
}
\examples{
\donttest{
KHQConvKHQ5D(scores = KHQ_Conv_KHQ5D_data, ignore.invalid = TRUE)

KHQConvKHQ5D(scores = KHQ_Conv_KHQ5D_data, save.xlsx = FALSE,
  filename = "KHQ_conv_KHQ5D.xlsx", sheetName = "Scores",
  ignore.invalid = TRUE)
}
}
\references{
Brazier J, Czoski-Murray C, Roberts J, Brown M, Symonds T, Kelleher C.
Estimation of a preference-based index from a condition-specific measure:
the King's Health Questionnaire. Med Decis Making. 2008 Jan-Feb;28(1):113-26.
doi:10.1177/0272989X07301820.
\href{https://pubmed.ncbi.nlm.nih.gov/17641139/}{PubMed}
}
\keyword{dataset}
