% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk3g.r
\docType{class}
\name{rkg3}
\alias{rkg3}
\title{The 'rkg3' class object}
\format{
\code{\link{R6Class}} object.
}
\value{
an  \code{\link{R6Class}} object which can be used for improving ode parameters estimation by using ode as a regularizer.
}
\description{
This class provides advanced gradient matching method by using the ode as a regularizer.
}
\section{Methods}{

\describe{
  \item{\code{iterate(iter,innerloop,lamb)}}{Iteratively updating ode parameters and interpolation regression coefficients.} 
  \item{\code{witerate(iter,innerloop,dtilda,lamb)}}{Iteratively updating ode parameters and the warped interpolation regression coefficients.}  
  \item{\code{full(par,lam)}}{Updating ode parameters and rkhs interpolation regression coefficients simultaneously. This method is slow but guarantee convergence.} }
}

\author{
Mu Niu, \email{mu.niu@glasgow.ac.uk}
}
\keyword{data}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{rk}}{the 'rkhs' class object containing the interpolation information for each state of the ode.}

\item{\code{ode_m}}{the 'ode' class object containing the information about the odes.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{ode_m}}{the 'ode' class object containing the information about the odes.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-rkg3-new}{\code{rkg3$new()}}
\item \href{#method-rkg3-greet}{\code{rkg3$greet()}}
\item \href{#method-rkg3-add}{\code{rkg3$add()}}
\item \href{#method-rkg3-iterate}{\code{rkg3$iterate()}}
\item \href{#method-rkg3-witerate}{\code{rkg3$witerate()}}
\item \href{#method-rkg3-full}{\code{rkg3$full()}}
\item \href{#method-rkg3-wfull}{\code{rkg3$wfull()}}
\item \href{#method-rkg3-opfull}{\code{rkg3$opfull()}}
\item \href{#method-rkg3-wopfull}{\code{rkg3$wopfull()}}
\item \href{#method-rkg3-cross}{\code{rkg3$cross()}}
\item \href{#method-rkg3-fullos}{\code{rkg3$fullos()}}
\item \href{#method-rkg3-clone}{\code{rkg3$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rkg3-new"></a>}}
\if{latex}{\out{\hypertarget{method-rkg3-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rkg3$new(rk = NULL, odem = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rkg3-greet"></a>}}
\if{latex}{\out{\hypertarget{method-rkg3-greet}{}}}
\subsection{Method \code{greet()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rkg3$greet()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rkg3-add"></a>}}
\if{latex}{\out{\hypertarget{method-rkg3-add}{}}}
\subsection{Method \code{add()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rkg3$add(x)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rkg3-iterate"></a>}}
\if{latex}{\out{\hypertarget{method-rkg3-iterate}{}}}
\subsection{Method \code{iterate()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rkg3$iterate(iter, innerloop, lamb)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rkg3-witerate"></a>}}
\if{latex}{\out{\hypertarget{method-rkg3-witerate}{}}}
\subsection{Method \code{witerate()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rkg3$witerate(iter, innerloop, dtilda, lamb)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rkg3-full"></a>}}
\if{latex}{\out{\hypertarget{method-rkg3-full}{}}}
\subsection{Method \code{full()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rkg3$full(par, lam)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rkg3-wfull"></a>}}
\if{latex}{\out{\hypertarget{method-rkg3-wfull}{}}}
\subsection{Method \code{wfull()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rkg3$wfull(par, lam, dtilda)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rkg3-opfull"></a>}}
\if{latex}{\out{\hypertarget{method-rkg3-opfull}{}}}
\subsection{Method \code{opfull()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rkg3$opfull(lam)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rkg3-wopfull"></a>}}
\if{latex}{\out{\hypertarget{method-rkg3-wopfull}{}}}
\subsection{Method \code{wopfull()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rkg3$wopfull(lam, dtilda)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rkg3-cross"></a>}}
\if{latex}{\out{\hypertarget{method-rkg3-cross}{}}}
\subsection{Method \code{cross()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rkg3$cross(lam, testX, testY)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rkg3-fullos"></a>}}
\if{latex}{\out{\hypertarget{method-rkg3-fullos}{}}}
\subsection{Method \code{fullos()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rkg3$fullos(par)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rkg3-clone"></a>}}
\if{latex}{\out{\hypertarget{method-rkg3-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rkg3$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
