% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F1.R
\name{F1.diffeek}
\alias{F1.diffeek}
\title{computes F1 score for jointnet result}
\usage{
\method{F1}{diffeek}(result, simulatedgraphs, ...)
}
\arguments{
\item{result}{output generated from any one of the jointnet algorithms}

\item{simulatedgraphs}{$simulatedgraphs from function simulation()}

\item{...}{unused}
}
\description{
computes F1 score for jointnet result
}
\examples{
library(JointNets)
simulationresult = simulation(p = 20,  n = c(100,100))
truth = simulationresult$simulatedgraphs
result = diffeek(simulationresult$simulatedsamples[[1]],
simulationresult$simulatedsamples[[2]],
W = matrix(1,20,20), g = rep(0,20),epsilon = 0.2,
lambda = 0.4,covType = "cov")
F1(result,truth)
}
