% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predDF}
\alias{predDF}
\alias{predDF.JointAI}
\alias{predDF.formula}
\title{Create a new dataframe for prediction}
\usage{
predDF(object, ...)

\method{predDF}{JointAI}(object, var, length = 100, ...)

\method{predDF}{formula}(formula, dat, var, length = 100, ...)
}
\arguments{
\item{object}{object inheriting from class 'JointAI'}

\item{...}{optional, additional arguments (currently not used)}

\item{var}{name of variable that should be varying}

\item{length}{number of values used in the sequence when \code{var} is continuous}

\item{formula}{a two sided model formula (see \code{\link[stats]{formula}})}

\item{dat}{original data}
}
\description{
Build a \code{data.frame} for prediction, where one variable
varies and all other variables are set to the reference value (median for
continuous variables).
}
\examples{
# fit a JointAI model
mod <- lm_imp(y ~ C1 + C2 + M2, data = wideDF, n.iter = 100)

# generate a dataframe with varying "C2" and reference values for all other variables in the model
newDF <- predDF(mod, var = "C2")

head(newDF)

}
\seealso{
\code{\link{predict.JointAI}}, \code{\link{lme_imp}}, \code{\link{glm_imp}},
          \code{\link{lm_imp}}
}
