% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{traceplot}
\alias{traceplot}
\alias{traceplot.mcmc.list}
\alias{traceplot.JointAI}
\title{Traceplot of a JointAI model}
\usage{
traceplot(object, ...)

\method{traceplot}{mcmc.list}(object, start = NULL, end = NULL,
  thin = NULL, ...)

\method{traceplot}{JointAI}(object, start = NULL, end = NULL,
  thin = NULL, subset = c(analysis_main = TRUE), nrow = NULL,
  ncol = NULL, keep_aux = FALSE, use_ggplot = FALSE, warn = TRUE,
  ...)
}
\arguments{
\item{object}{object inheriting from class 'JointAI'}

\item{...}{Arguments passed on to \code{graphics::matplot}
\describe{
  \item{lty}{vector of line types, widths, and end styles.
    The first element is for the first column, the second element for
    the second column, etc., even if lines are not plotted for all
    columns. Line types will be used cyclically until all plots are
    drawn.}
  \item{lwd}{vector of line types, widths, and end styles.
    The first element is for the first column, the second element for
    the second column, etc., even if lines are not plotted for all
    columns. Line types will be used cyclically until all plots are
    drawn.}
  \item{lend}{vector of line types, widths, and end styles.
    The first element is for the first column, the second element for
    the second column, etc., even if lines are not plotted for all
    columns. Line types will be used cyclically until all plots are
    drawn.}
  \item{col}{vector of colors.  Colors are used cyclically.}
  \item{cex}{vector of character expansion sizes, used cyclically.
    This works as a multiple of \code{\link{par}("cex")}.  \code{NULL} is
    equivalent to \code{1.0}. }
  \item{bg}{vector of background (fill) colors for the open plot
    symbols given by \code{pch = 21:25} as in \code{\link{points}}.  The
    default \code{NA} corresponds to the one of the underlying function
    \code{\link{plot.xy}}.}
  \item{xlim}{ranges of x and y axes, as in \code{\link{plot}}.}
  \item{ylim}{ranges of x and y axes, as in \code{\link{plot}}.}
  \item{add}{logical.  If \code{TRUE}, plots are added to current one,
    using \code{\link{points}} and \code{\link{lines}}.}
  \item{verbose}{logical.  If \code{TRUE}, write one line of what is
    done.}
}}

\item{start}{the first iteration of interest (see \code{\link[coda]{window.mcmc}})}

\item{end}{the last iteration of interest (see \code{\link[coda]{window.mcmc}})}

\item{thin}{thinning interval (see \code{\link[coda]{window.mcmc}})}

\item{subset}{subset of parameters/variables/nodes (columns in the MCMC sample).
Uses the same logic as the argument \code{monitor_params} in
\code{\link{lm_imp}}, \code{\link{glm_imp}}, \code{\link{clm_imp}},
\code{\link{lme_imp}}, \code{\link{glme_imp}}, \code{\link{survreg_imp}}
and \code{\link{coxph_imp}}.}

\item{nrow}{optional number of rows and columns in the plot layout;
automatically chosen if unspecified}

\item{ncol}{optional number of rows and columns in the plot layout;
automatically chosen if unspecified}

\item{keep_aux}{logical; Should constant effects of auxiliary variables be kept in the output?}

\item{use_ggplot}{logical; Should ggplot be used instead of the base graphics?}

\item{warn}{logical; should warnings be given? Default is
\code{TRUE}. Note: this applies only to warnings
given directly by \strong{JointAI}.}
}
\description{
Creates a set of traceplots from the MCMC sample of an object of class "JointAI".
}
\examples{
# fit a JointAI model
mod <- lm_imp(y~C1 + C2 + M2, data = wideDF, n.iter = 100)


# Example 1: simple traceplot
traceplot(mod)


# Example 2: ggplot version of traceplot
traceplot(mod, use_ggplot = TRUE)


# Example 5: changing how the ggplot version looks (using standard ggplot syntax)
library(ggplot2)

traceplot(mod, use_ggplot = TRUE) +
  theme(legend.position = 'botto') +
  xlab('iteration') +
  ylab('value') +
  scale_color_discrete(name = 'chain')


}
\seealso{
\code{\link{summary.JointAI}}, \code{\link{lme_imp}}, \code{\link{glm_imp}},
         \code{\link{lm_imp}}, \code{\link{densplot}}
         The vignette \href{https://nerler.github.io/JointAI/articles/SelectingParameters.html}{Parameter Selection}
         contains some examples how to specify the parameter \code{subset}.
}
