/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.DataStructures.Data;

import java.io.Serializable;
import java.util.Hashtable;
import org.omegahat.DataStructures.Data.AbstractVariable;
import org.omegahat.DataStructures.Data.VariableInt;

public class RealVariable
extends AbstractVariable
implements VariableInt,
Serializable {
    protected double[] vals;

    public RealVariable() {
    }

    public RealVariable(int n) {
        this.vals = new double[n];
    }

    public RealVariable(int n, Hashtable hashtable) {
        this(n);
        this.metaData(hashtable);
    }

    public RealVariable(double[] dArray) {
        this.vals = dArray;
    }

    public void add(double d, int n) {
        if (n < 0) {
            if (this.vals == null) {
                this.vals = new double[1];
            } else {
                double[] dArray = new double[this.vals.length + 1];
                System.arraycopy(this.vals, 0, dArray, 0, this.vals.length);
                this.vals = dArray;
            }
            this.vals[this.vals.length - 1] = d;
        } else {
            this.values()[n] = d;
        }
    }

    public void add(Object object, int n) {
        double d = Double.NaN;
        if (object instanceof Number) {
            d = ((Number)object).doubleValue();
        } else {
            try {
                d = Double.parseDouble(object.toString().trim());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.add(d, n);
    }

    public Object asArray() {
        return this.vals;
    }

    public Object asArrayCopy() {
        double[] dArray = new double[this.vals.length];
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = this.vals[n];
            ++n;
        }
        return dArray;
    }

    public double[] getValues() {
        return this.values();
    }

    public long numObservations() {
        return this.vals == null ? 0L : (long)this.vals.length;
    }

    public String toString() {
        String string = "RealVariable: # obs = " + this.numObservations();
        return string;
    }

    public String[] toStringArray() {
        String[] stringArray = new String[this.vals.length];
        int n = 0;
        while (n < this.vals.length) {
            stringArray[n] = String.valueOf(this.vals[n]);
            ++n;
        }
        return stringArray;
    }

    public Object value(int n) {
        return new Double(this.vals[n]);
    }

    public double[] values() {
        return this.vals;
    }

    public double[] values(boolean bl) {
        double[] dArray = new double[this.vals.length];
        System.arraycopy(dArray, 0, this.vals, 0, this.vals.length);
        return dArray;
    }

    public VariableInt values(int[] nArray) {
        RealVariable realVariable = new RealVariable(nArray.length);
        int n = 0;
        while (n < nArray.length) {
            realVariable.vals[n] = this.vals[nArray[n]];
            ++n;
        }
        return realVariable;
    }
}

