/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.GUI;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSplitPane;
import org.omegahat.Environment.GUI.EvaluatorStatusBar;
import org.omegahat.Environment.GUI.MenuDescription;
import org.omegahat.Environment.GUI.ToolsPanel;
import org.omegahat.Environment.GUI.WorkArea;
import org.omegahat.Environment.GUI.omega;
import org.omegahat.Environment.Interpreter.BasicEvaluator;
import org.omegahat.Environment.Interpreter.Evaluator;
import org.omegahat.Environment.Interpreter.EvaluatorManager;

public class OmegaInterface
extends JFrame
implements ActionListener {
    protected ToolsPanel tools_panel = null;
    protected WorkArea work_area = null;
    protected Evaluator evaluator = null;
    protected omega app = null;
    protected double SplitProportion = 0.65;

    public OmegaInterface() {
        this(new BasicEvaluator());
    }

    public OmegaInterface(String string, EvaluatorManager evaluatorManager, omega omega2) {
        super(string);
        if (evaluatorManager != null) {
            try {
                this.evaluator = evaluatorManager.evaluator(true);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("Couldn't create an evaluator from the manager");
                classNotFoundException.printStackTrace();
            }
        }
        this.app = omega2;
        this.make();
    }

    public OmegaInterface(Evaluator evaluator) {
        this((EvaluatorManager)null);
        this.evaluator = evaluator;
    }

    public OmegaInterface(EvaluatorManager evaluatorManager) {
        this("Omega", evaluatorManager, null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JMenuItem) {
            this.menuActionPerformed((JMenuItem)object, actionEvent);
        }
    }

    public JMenu createMenu(String string, MenuDescription menuDescription) {
        JMenu jMenu = new JMenu(string);
        JMenuItem jMenuItem = null;
        int n = 0;
        while (n < menuDescription.size()) {
            jMenuItem = menuDescription.menuItem(n);
            jMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            ++n;
        }
        return jMenu;
    }

    protected JMenuBar createMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        String[] stringArray = new String[]{"Print", "Close", "Quit"};
        String[] stringArray2 = new String[]{"Contents"};
        String[] stringArray3 = new String[]{"Show", "Load", "Save"};
        jMenuBar.add(this.createMenu("File", new MenuDescription(stringArray)));
        jMenuBar.add(this.createMenu("History", new MenuDescription(stringArray3)));
        JMenu jMenu = this.createMenu("Help", new MenuDescription(stringArray2));
        jMenuBar.add(jMenu);
        this.getRootPane().setJMenuBar(jMenuBar);
        return jMenuBar;
    }

    public Evaluator evaluator() {
        return this.evaluator;
    }

    public Evaluator evaluator(Evaluator evaluator) {
        this.evaluator = evaluator;
        return this.evaluator();
    }

    public boolean make() {
        this.getContentPane().setLayout(new BorderLayout());
        JSplitPane jSplitPane = new JSplitPane(1);
        this.getContentPane().add("Center", jSplitPane);
        this.tools_panel = new ToolsPanel(this.evaluator);
        this.work_area = new WorkArea(this.evaluator);
        jSplitPane.setLeftComponent(this.work_area);
        jSplitPane.setRightComponent(this.tools_panel);
        jSplitPane.setDividerLocation(this.SplitProportion);
        jSplitPane.setOneTouchExpandable(true);
        this.getContentPane().add("South", new EvaluatorStatusBar(this.evaluator));
        this.createMenus();
        return true;
    }

    public void menuActionPerformed(JMenuItem jMenuItem, ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Quit")) {
            this.app.quit();
        } else if (string.equals("Close")) {
            this.app.closeFrame(this);
        }
    }

    public Object output() {
        return this.work_area.output();
    }
}

