/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.IO;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Vector;
import org.omegahat.Environment.IO.InputConsumer;
import org.omegahat.Environment.IO.InputSupplier;
import org.omegahat.Environment.IO.PromptSource;

public class InputReader
extends BufferedReader
implements InputSupplier,
Runnable {
    protected StringBuffer current_line = new StringBuffer();
    protected Vector consumers = null;
    protected PromptSource promptSource = null;

    public InputReader() {
        this(System.in);
    }

    public InputReader(InputStream inputStream) {
        this(new InputStreamReader(inputStream));
    }

    public InputReader(InputStreamReader inputStreamReader) {
        super(inputStreamReader);
    }

    public InputReader(PromptSource promptSource) {
        this();
        this.promptSource(promptSource);
    }

    public boolean addInputConsumer(InputConsumer inputConsumer) {
        if (this.consumers == null) {
            this.consumers = new Vector(2);
        }
        this.consumers.addElement(inputConsumer);
        return true;
    }

    public String defaultPrompt() {
        return "> ";
    }

    public Object getInput() {
        return this.current_line.toString();
    }

    public void notifyConsumers(String string) {
        if (this.consumers == null) {
            return;
        }
        Enumeration enumeration = this.consumers.elements();
        while (enumeration.hasMoreElements()) {
            InputConsumer inputConsumer = (InputConsumer)enumeration.nextElement();
            inputConsumer.inputReady(this);
        }
    }

    public String prompt() {
        String string = this.defaultPrompt();
        if (this.promptSource() != null) {
            string = this.promptSource().prompt();
        }
        System.out.print(string);
        return string;
    }

    public PromptSource promptSource() {
        return this.promptSource;
    }

    public PromptSource promptSource(PromptSource promptSource) {
        this.promptSource = promptSource;
        return this.promptSource();
    }

    public boolean removeInputConsumer(InputConsumer inputConsumer) {
        if (this.consumers == null || !this.consumers.contains(inputConsumer)) {
            return false;
        }
        this.consumers.removeElement(inputConsumer);
        return true;
    }

    public void run() {
        boolean bl = false;
        while (true) {
            this.current_line.setLength(0);
            try {
                boolean bl2;
                this.prompt();
                do {
                    String string;
                    if (bl2 = (string = this.readLine()).endsWith("//")) {
                        string = string.substring(0, string.length() - 2);
                    }
                    this.current_line.append(string);
                    this.current_line.append("\n");
                } while (bl2);
            }
            catch (IOException iOException) {
                System.err.println("Input error: " + iOException);
                continue;
            }
            if (this.current_line == null || this.current_line.length() <= 1) continue;
            this.notifyConsumers(this.current_line.toString());
        }
    }
}

