% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot.modelDiagnostics.lm}
\alias{plot.modelDiagnostics.lm}
\title{Plot Diagnostics for an lm model}
\usage{
\method{plot}{modelDiagnostics.lm}(x, y, plot = TRUE, ask = TRUE, ncol,
  ...)
}
\arguments{
\item{x}{A fitted model object from lm.}

\item{y}{Included to match the generic. Not used.}

\item{plot}{A logical value whether or not to plot the results or
simply return the graaphical  objects.}

\item{ask}{A logical whether to ask before changing plots.
Only applies to interactive environments.}

\item{ncol}{The number of columns to use for plots.
Missing by default which means individual plots are created.
If specified, plots are put together in a grid.}

\item{...}{Included to match the generic. Not used.}
}
\value{
a list including plots of the residuals,
  residuals versus fitted values, and one list for
  plots of all random effects and finally a data table with
  any extreme values identified
}
\description{
This function creates a number of diagnostic plots
from lm models. It relies heavily on the \code{testdistr}
function.
}
\examples{
testm <- stats::lm(mpg ~ hp * factor(cyl), data = mtcars)

md <- modelDiagnostics(testm, ev.perc = .1)

plot(md)
plot(md, ncol = 2)

## clean up
rm(testm, md)
}
\keyword{plot}
