% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{R2LMER}
\alias{R2LMER}
\title{Calculates the R2 from lmer models}
\usage{
R2LMER(model, modelsum, cluster = FALSE)
}
\arguments{
\item{model}{A model estimated by \code{lmer}.}

\item{modelsum}{The saved model summary (i.e., \code{summary(model)}).}

\item{cluster}{A logical whether to calculate individual pseudo R2 values by
cluster unit (if \code{TRUE}) or the marginal and conditional R2 for the
overall model (if \code{FALSE}, the default).}
}
\value{
a named vector with the marginal and conditional R2 values,
  if \code{CLUSTER = FALSE}, otherwise, a data table with the pseudo R2
  for each cluster unit.
}
\description{
For pseudo R2 by cluster, the squared correlation between observed
and predicted values for each cluster unit is returned.  For the overall model,
the marginal and conditional R2 are calculated as described in the references.
}
\examples{

\dontrun{
data(aces_daily)
m1 <- lme4::lmer(NegAff ~ STRESS + (1 + STRESS | UserID),
  data = aces_daily)

R2LMER(m1, summary(m2))

rm(m1)
}
}
\references{
For estimating the marginal and conditional R-squared values,
  see: Nakagawa, S. and Schielzeth, H. (2013). A general and simple method
  for obtaining R2 from generalized linear mixed-effects models.
  Methods in Ecology and Evolution, 4(2), 133-142. as well as:
  Johnson, P. C. (2014). Extension of Nakagawa & Schielzeth's R2GLMM to
  random slopes models. Methods in Ecology and Evolution, 5(9), 944-946.
}
\keyword{utils}
