% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{SimDataO}
\alias{SimDataO}
\title{Data simulation of ordinal outcomes and competing risks}
\usage{
SimDataO(k_val, p1_val, p1a_val, p2_val, g_val, truebeta, truetheta,
  truegamma, randeffect, yfn, cfn, mfn)
}
\arguments{
\item{k_val}{The number of subjects in study.}

\item{p1_val}{The dimension of fixed effects in longitudinal measurements.}

\item{p1a_val}{The dimension of random effects in longitudinal measurements.}

\item{p2_val}{The dimension of fixed effects in competing risks failure time data.}

\item{g_val}{The number of type of failure in competing risks data.}

\item{truebeta}{True values for beta, the longitudinal coefficients.}

\item{truetheta}{True values for theta, subset of the non-proportional odds longitudinal coefficients.}

\item{truegamma}{True values for gamma, the survival coefficients.}

\item{randeffect}{True values for random effects in longitudinal  and competing risks parts,namely in the order of \eqn{\sigma_b},\eqn{\nu_2},\eqn{\sigma_u}.}

\item{yfn}{Filename of genereated Y matrix for longitudinal measurements in long format.}

\item{cfn}{Filename of genereated C matrix for competing risks failure time data.}

\item{mfn}{Filename of genereated M vector to indicate the number of longitudinal measurements per subject.}
}
\value{
Files with names yfn, cfn and mfn.
\tabular{ll}{
\code{censoring_rate} \tab Censoring rate of the survival data. \cr
\code{rate1} \tab Censoring rate of competing risk 1. \cr
\code{rate2} \tab Censoring rate of competing risk 2. \cr
\code{yfn} \tab Filename of genereated Y matrix for longitudinal measurements. \cr
\code{cfn} \tab Filename of genereated C matrix for competing risks failure time data. \cr
\code{mfn} \tab  Filename of genereated M vector to indicate the number of longitudinal measurements per subject.
 }
}
\description{
Simulation of ordinal longitudinal outcome and competing risks data
Currently, only the simulation in Li et al(2010) is implemented.
}
\examples{
# A toy example testint data generations
require(JMcmprsk)
set.seed(123)
yfn=tempfile(pattern = "", fileext = ".txt")
cfn=tempfile(pattern = "", fileext = ".txt")
mfn=tempfile(pattern = "", fileext = ".txt")
 k_val=50;p1_val=3;p1a_val=1; p2_val=2;g_val=2;
truebeta=c(-1,1.5,0.8);truetheta=c(-0.5,1);truegamma=c(0.8,-1,0.5,-1); randeffect=c(1,0.5,0.5);
#writing files
SimDataO(k_val, p1_val, p1a_val, p2_val, g_val,
      truebeta, truetheta, truegamma, randeffect, yfn,  cfn,  mfn)
\donttest{
jmo(p=3,s=1, yfn,cfn,mfn,point=10,do.trace = TRUE)
}
}
\references{
\itemize{
\item Ning Li,Robert M. Elashoff,Gang Li and Jeffrey Saver. "Joint modeling of longitudinal ordinal data and competing risks survival times and analysis of the NINDS rt-PA stroke trial." Statistics in medicine 29.5 (2010): 546-557.
}
}
\seealso{
\code{\link{SimDataC}}
}
