/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR;

import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.rosuda.JGR.JGR;
import org.rosuda.REngine.JRI.JRIEngine;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngineException;

final class MonitoredEval {
    volatile boolean done = false;
    volatile REXP result;
    int interval;
    int checkInterval;
    boolean ask;

    public MonitoredEval(int inter, boolean ak) {
        this.checkInterval = this.interval = inter;
        this.ask = ak;
    }

    protected void startMonitor() {
        int t = 0;
        while (true) {
            try {
                Thread.sleep(this.checkInterval);
            }
            catch (InterruptedException e) {
                return;
            }
            if (this.done) {
                return;
            }
            if (t + this.checkInterval < this.interval) {
                t += this.checkInterval;
                continue;
            }
            int cancel = this.ask ? JOptionPane.showConfirmDialog(null, "This R process is taking some time.\nWould you like to cancel it?", "Cancel R Process", 0) : 0;
            if (cancel == 0) {
                ((JRIEngine)JGR.getREngine()).getRni().rniStop(0);
                return;
            }
            t = 0;
        }
    }

    public REXP run(String cmd) {
        try {
            if (SwingUtilities.isEventDispatchThread() && this.ask) {
                final String c = cmd;
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            MonitoredEval.this.result = JGR.eval(c);
                        }
                        catch (REngineException e) {
                            MonitoredEval.this.result = null;
                        }
                        catch (REXPMismatchException e) {
                            MonitoredEval.this.result = null;
                        }
                        MonitoredEval.this.done = true;
                    }
                }).start();
                this.checkInterval = 10;
                this.startMonitor();
            } else {
                new Thread(new Runnable(){

                    public void run() {
                        MonitoredEval.this.startMonitor();
                    }
                }).start();
                this.result = JGR.eval(cmd);
            }
            this.done = true;
            return this.result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void assign(String symbol, REXP value) {
        if (SwingUtilities.isEventDispatchThread() && this.ask) {
            final String sym = symbol;
            final REXP val = value;
            new Thread(new Runnable(){

                public void run() {
                    try {
                        JGR.getREngine().assign(sym, val);
                    }
                    catch (REngineException e) {
                        MonitoredEval.this.result = null;
                    }
                    catch (REXPMismatchException e) {
                        MonitoredEval.this.result = null;
                    }
                    MonitoredEval.this.done = true;
                }
            }).start();
            this.checkInterval = 10;
            this.startMonitor();
        } else {
            new Thread(new Runnable(){

                public void run() {
                    MonitoredEval.this.startMonitor();
                }
            }).start();
            try {
                JGR.getREngine().assign(symbol, value);
                this.done = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

