/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase;

import java.util.ArrayList;
import java.util.List;
import org.rosuda.ibase.NotifyMsg;
import org.rosuda.ibase.SMarker;
import org.rosuda.ibase.SVar;
import org.rosuda.util.Global;
import org.rosuda.util.ProgressDlg;
import org.rosuda.util.Stopwatch;

public class SVarInt
extends SVar {
    static int[] temp;
    public int[] cont;
    int insertPos = 0;
    List cats;
    List ccnts;
    int[] ranks = null;

    public SVarInt(String Name, int len) {
        super(Name, false);
        if (len < 0) {
            len = 0;
        }
        this.guessing = false;
        this.contentsType = 1;
        this.isnum = true;
        this.cont = new int[len];
        for (int i = 0; i < this.cont.length; ++i) {
            this.cont[i] = SVar.int_NA;
        }
        this.insertPos = len;
    }

    public SVarInt(String Name, int[] d) {
        this(Name, d, true);
    }

    public SVarInt(String Name, int[] d, boolean copyContents) {
        super(Name, false);
        this.insertPos = d.length;
        this.guessing = false;
        this.contentsType = 1;
        this.isnum = true;
        if (!copyContents) {
            this.cont = d;
        } else {
            this.cont = new int[d.length];
            System.arraycopy(d, 0, this.cont, 0, d.length);
        }
        this.updateCache();
    }

    private void updateCache() {
        boolean firstValid = true;
        this.max = 0.0;
        this.min = 0.0;
        for (int i = 0; i < this.cont.length; ++i) {
            if (this.cont[i] == int_NA) {
                ++this.missingCount;
                continue;
            }
            if (firstValid) {
                this.min = this.max = (double)this.cont[i];
                firstValid = false;
                continue;
            }
            if ((double)this.cont[i] > this.max) {
                this.max = this.cont[i];
                continue;
            }
            if (!((double)this.cont[i] < this.min)) continue;
            this.min = this.cont[i];
        }
    }

    public int size() {
        return this.cont.length;
    }

    public void categorize(boolean rebuild) {
        if (this.cat && !rebuild) {
            return;
        }
        this.cats = new ArrayList();
        this.ccnts = new ArrayList();
        this.cat = true;
        if (!this.isEmpty()) {
            int ci = 0;
            while (ci < this.cont.length) {
                String oo = this.cont[ci] == int_NA ? "NA" : Integer.toString(this.cont[ci]);
                int i = this.cats.indexOf(oo);
                if (i == -1) {
                    this.cats.add(oo);
                    this.ccnts.add(new Integer(1));
                    continue;
                }
                this.ccnts.set(i, new Integer((Integer)this.ccnts.get(i) + 1));
            }
            if (this.isNum()) {
                this.sortCategories(1);
            }
        }
        this.NotifyAll(new NotifyMsg(this, 12290));
    }

    public void sortCategories(int method) {
        if (!this.isCat() || this.cats.size() < 2) {
            return;
        }
        Stopwatch sw = null;
        if (Global.DEBUG > 0) {
            sw = new Stopwatch();
            System.out.println("Sorting variable \"" + this.name + "\"");
        }
        List ocats = this.cats;
        List occnts = this.ccnts;
        this.cats = new ArrayList(ocats.size());
        this.ccnts = new ArrayList(occnts.size());
        boolean found = true;
        int cs = ocats.size();
        while (found) {
            found = false;
            int p = -1;
            double min = -0.01;
            boolean gotmin = false;
            String mino = null;
            for (int i = 0; i < cs; ++i) {
                Object o = ocats.get(i);
                if (o == null) continue;
                if (method == 1) {
                    double val = -0.01;
                    try {
                        val = ((Number)o).doubleValue();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (!gotmin) {
                        gotmin = true;
                        min = val;
                        p = i;
                        continue;
                    }
                    if (!(val < min)) continue;
                    min = val;
                    p = i;
                    continue;
                }
                if (!gotmin) {
                    gotmin = true;
                    mino = o.toString();
                    p = i;
                    continue;
                }
                if (mino.compareTo(o.toString()) <= 0) continue;
                mino = o.toString();
                p = i;
            }
            found = gotmin;
            if (!found) continue;
            this.cats.add(ocats.get(p));
            this.ccnts.add(occnts.get(p));
            ocats.set(p, null);
        }
        if (Global.DEBUG > 0) {
            sw.profile("sorted");
        }
    }

    public void dropCat() {
        this.cats = null;
        this.ccnts = null;
        this.cat = false;
        this.NotifyAll(new NotifyMsg(this, 12290));
    }

    public void setCategorical(boolean nc) {
        if (!nc) {
            this.cat = false;
        } else if (this.cats == null) {
            this.categorize();
        } else {
            this.cat = true;
        }
    }

    public boolean add(Object o) {
        if (this.insertPos >= this.cont.length) {
            return false;
        }
        if (this.cacheRanks && this.ranks != null) {
            this.ranks = null;
        }
        int val = int_NA;
        if (o != null) {
            try {
                val = Integer.parseInt(o.toString());
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        return this.add(val);
    }

    public boolean add(double d) {
        return this.add((int)d);
    }

    public boolean add(int d) {
        if (this.insertPos >= this.cont.length) {
            return false;
        }
        if (this.cat) {
            String oo = d == int_NA ? "NA" : Integer.toString(d);
            int i = this.cats.indexOf(oo);
            if (i == -1) {
                this.cats.add(oo);
                this.ccnts.add(new Integer(1));
            } else {
                this.ccnts.set(i, new Integer((Integer)this.ccnts.get(i) + 1));
            }
        }
        if (d != int_NA) {
            if ((double)d > this.max) {
                this.max = d;
            }
            if ((double)d < this.min) {
                this.min = d;
            }
        } else {
            ++this.missingCount;
        }
        this.cont[this.insertPos++] = d;
        this.NotifyAll(new NotifyMsg(this, 12289));
        return true;
    }

    public boolean replace(int i, Object o) {
        try {
            this.replace(i, Integer.parseInt(o.toString()));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean replace(int i, int d) {
        if (i < 0 || i >= this.cont.length || this.isCat()) {
            return false;
        }
        this.cont[i] = d;
        return true;
    }

    public boolean replaceAll(int[] d) {
        if (this.cont.length != d.length) {
            return false;
        }
        System.arraycopy(d, 0, this.cont, 0, d.length);
        this.updateCache();
        return true;
    }

    public Object at(int i) {
        return i < 0 || i >= this.insertPos || this.cont[i] == SVar.int_NA ? null : new Integer(this.cont[i]);
    }

    public double atD(int i) {
        return i < 0 || i >= this.insertPos ? double_NA : (double)this.cont[i];
    }

    public double atF(int i) {
        return i < 0 || i >= this.insertPos ? 0.0 : (double)this.cont[i];
    }

    public int atI(int i) {
        return i < 0 || i >= this.insertPos ? int_NA : this.cont[i];
    }

    public String asS(int i) {
        return i < 0 || i >= this.insertPos ? null : Integer.toString(this.cont[i]);
    }

    public int getCatIndex(Object o) {
        if (this.cats == null) {
            return -1;
        }
        Object oo = o;
        if (o == null) {
            oo = "NA";
        }
        return this.cats.indexOf(oo);
    }

    public int getCatIndex(int i) {
        try {
            return this.getCatIndex(this.elementAt(i));
        }
        catch (Exception e) {
            return -1;
        }
    }

    public Object getCatAt(int i) {
        if (this.cats == null) {
            return null;
        }
        try {
            return this.cats.get(i);
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getSizeCatAt(int i) {
        if (this.cats == null) {
            return -1;
        }
        try {
            return (Integer)this.ccnts.get(i);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public int getSizeCat(Object o) {
        if (this.cats == null) {
            return -1;
        }
        int i = this.cats.indexOf(o);
        return i == 1 ? -1 : (Integer)this.ccnts.get(i);
    }

    public int getNumCats() {
        if (this.cats == null) {
            return 0;
        }
        return this.cats.size();
    }

    public Object[] getCategories() {
        if (this.cats == null) {
            return null;
        }
        Object[] c = new Object[this.cats.size()];
        this.cats.toArray(c);
        return c;
    }

    public boolean remove(int index) {
        int length = this.size();
        temp = new int[--length];
        try {
            int i = 0;
            for (int z = 0; z < this.cont.length && i < temp.length; ++i, ++z) {
                if (i == index) {
                    ++z;
                }
                SVarInt.temp[i] = this.cont[z];
            }
            this.cont = temp;
            this.insertPos = this.cont.length;
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean insert(Object o, int index) {
        int length = this.size();
        temp = new int[++length];
        try {
            int i = 0;
            for (int z = 0; z < this.cont.length && i < temp.length; ++i, ++z) {
                if (i == index) {
                    --z;
                    continue;
                }
                SVarInt.temp[i] = this.cont[z];
            }
            this.cont = temp;
            this.cont[index] = o == null ? int_NA : Integer.parseInt(o.toString());
            this.insertPos = this.cont.length;
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public int[] getRanked(SMarker m, int markspec) {
        int ct;
        Stopwatch sw = new Stopwatch();
        if (this.isCat() || !this.isNum() || this.size() == 0) {
            return null;
        }
        if (m == null && this.cacheRanks && this.ranks != null) {
            return this.ranks;
        }
        int[] r = null;
        if (!this.cacheRanks || this.ranks == null) {
            ProgressDlg pd = null;
            if (this.size() > 1000) {
                pd = new ProgressDlg("Variable " + this.getName());
                pd.begin("Calculating ranks ...");
            }
            ct = this.size();
            r = new int[ct - this.missingCount];
            int zi = 0;
            int[] da = this.cont;
            for (int z = 0; z < ct; ++z) {
                if (da[z] == int_NA) continue;
                r[zi++] = z;
            }
            sw.profile("getRanked: pass 1: store relevant values");
            ct = r.length;
            for (int i = 0; i < ct - 1; ++i) {
                int d = da[r[i]];
                int j = ct - 1;
                if (pd != null && (i & 0xFF) == 0) {
                    pd.setProgress((int)((double)i * 99.0 / (double)ct));
                }
                while (j > i) {
                    int d2 = da[r[j]];
                    if (d2 < d) {
                        int xx = r[i];
                        r[i] = r[j];
                        r[j] = xx;
                        d = d2;
                    }
                    --j;
                }
            }
            if (pd != null) {
                pd.setProgress(99);
            }
            sw.profile("getRanked: pass 2: sort");
            if (this.cacheRanks) {
                this.ranks = r;
            }
            da = null;
            if (pd != null) {
                pd.end();
            }
            pd = null;
        } else {
            r = this.ranks;
        }
        if (m != null && r != null) {
            int i;
            int x = r.length;
            ct = 0;
            for (i = 0; i < x; ++i) {
                if (m.get(r[i]) != markspec) continue;
                ++ct;
            }
            if (ct == 0) {
                return null;
            }
            int[] mr = new int[ct];
            int mri = 0;
            for (i = 0; i < x; ++i) {
                if (m.get(r[i]) != markspec) continue;
                mr[mri++] = r[i];
            }
            r = null;
            r = mr;
        }
        return r;
    }

    public boolean hasEqualContents(int[] c2) {
        if (this.cont.length != c2.length) {
            return false;
        }
        for (int i = 0; i < this.cont.length; ++i) {
            if (this.cont[i] == c2[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "SVarInt(\"" + this.name + "\"," + (this.cat ? "cat," : "cont,") + (this.isnum ? "num," : "txt,") + "n=" + this.size() + "/" + this.cont.length + ",miss=" + this.missingCount + ")";
    }
}

