/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.rosuda.ibase.Common;
import org.rosuda.ibase.LoaderDelphiFilter;
import org.rosuda.ibase.MapSegment;
import org.rosuda.ibase.SVar;
import org.rosuda.ibase.SVarObj;
import org.rosuda.ibase.SVarSet;
import org.rosuda.util.Global;
import org.rosuda.util.ProgressDlg;
import org.rosuda.util.Stopwatch;
import org.rosuda.util.Tools;

public class Loader {
    public static void checkPolys(SVar psv, SVarSet vset) {
        for (int i = 0; i < psv.size(); ++i) {
            if (psv.at(i) != null) continue;
            Common.addWarning("Case at position " + (i + 1) + " has no associated polygons in variable \"" + psv.getName() + "\". (This is ok if it was intentional.)");
        }
        if (vset != null && psv.size() < vset.length()) {
            Common.addWarning("There are " + vset.length() + " cases in the dataset, but only " + psv.size() + " polygons in \"" + psv.getName() + "\". Maybe the attached polygons are incomplete.");
        }
    }

    public static int LoadData(BufferedReader r, SVarSet vset, long clen) throws Exception {
        Object smark = null;
        Object emark = null;
        boolean nid = true;
        long cl = 0L;
        long cpif = 0L;
        int pbg = 5;
        boolean inside = false;
        boolean isTree = false;
        boolean isData = true;
        boolean isPoly = false;
        boolean gotData = false;
        boolean gotTree = false;
        boolean gotNames = false;
        boolean preMark = smark != null;
        boolean rdsType = false;
        int presBase = 2;
        int oprog = -1;
        ProgressDlg pd = null;
        Vector<String> polyVars = new Vector<String>();
        Vector<SVarObj> polySVs = new Vector<SVarObj>();
        Vector<Double> px = new Vector<Double>();
        Vector<Double> py = new Vector<Double>();
        int polyPt = 0;
        String curPolyVar = null;
        SVar curPolySV = null;
        MapSegment[] mses = null;
        int msid = -1;
        if (clen > 10000L || vset != null && vset.count() > 0 && vset.at(0) != null && vset.at(0).size() > 2000) {
            pd = new ProgressDlg("Loading...");
            pd.setText("Initializing...");
            pd.show();
        }
        if (clen > 100000L) {
            pbg = 1;
        }
        int prevars = vset == null ? 0 : vset.count();
        Stopwatch sw = new Stopwatch(Global.DEBUG < 2);
        String dataSep = " ";
        while (r.ready()) {
            int prog;
            String s = r.readLine();
            if (clen > 0L && (prog = (int)((double)(cpif += (long)s.length()) / (double)clen * 100.0) / pbg * pbg) != oprog) {
                if (pd != null) {
                    pd.setProgress(prog);
                }
                oprog = prog;
            }
            if (s == null) break;
            if (vset != null && !gotData && !isTree && s.length() > 0) {
                isData = true;
            }
            if (isData) {
                if (s.indexOf("\t\t") > -1) {
                    int tti;
                    while ((tti = s.indexOf("\t\t")) > -1) {
                        s = s.substring(0, tti) + "\tNA" + s.substring(tti + 1);
                    }
                }
                if (!gotNames) {
                    if (s.length() > 0) {
                        if (pd != null) {
                            pd.setText("Loading dataset...");
                        }
                        if (s.indexOf("\t") > -1) {
                            dataSep = "\t";
                        } else if (s.charAt(0) == ' ' || s.charAt(0) == '\"') {
                            rdsType = true;
                            SVarObj idx = new SVarObj("index", false);
                            idx.setInternalType(4);
                            idx.getNotifier().beginBatch();
                            vset.add(idx);
                        }
                        StringTokenizer st = new StringTokenizer(s, dataSep);
                        while (st.hasMoreTokens()) {
                            boolean forceCat = false;
                            boolean forceNum = false;
                            boolean hasPoly = false;
                            String nam = st.nextToken();
                            if (nam.length() > 0 && s.charAt(0) == '\"') {
                                nam = nam.substring(1, nam.length() - 1);
                            }
                            int ca = 0;
                            boolean hadProbs = false;
                            String on = nam;
                            if (nam.length() > 1 && nam.charAt(0) == '/') {
                                char Mpref = nam.charAt(1);
                                if (Mpref == 'D') {
                                    forceCat = true;
                                }
                                if (Mpref == 'C') {
                                    forceNum = true;
                                }
                                if (Mpref == 'P') {
                                    hasPoly = true;
                                    polyVars.addElement(new String(nam));
                                }
                                nam = nam.substring(2);
                            }
                            while (ca < nam.length()) {
                                char c = nam.charAt(ca);
                                if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '.')) {
                                    hadProbs = true;
                                    nam = nam.replace(c, '.');
                                }
                                ++ca;
                            }
                            if (hadProbs) {
                                for (ca = 0; ca < nam.length() && nam.charAt(ca) == '.'; ++ca) {
                                }
                                if (ca > 0) {
                                    nam = nam.substring(ca);
                                }
                                if (nam.length() < 1 || nam.charAt(0) >= '0' && nam.charAt(0) <= '9') {
                                    nam = "v." + nam;
                                }
                                Common.addWarning("RTree.Load: Variable name \"" + on + "\" contains invalid characters and will be replaced by \"" + nam + "\".");
                            }
                            SVarObj nv = null;
                            nv = new SVarObj(nam);
                            if (vset.add(nv) < 0) {
                                Common.addWarning("RTree.Load: Variable \"" + nam + "\" occurs more than once in the header. Renaming to \"" + nam + "." + vset.count() + "\".");
                                Common.addWarning("            Please note that this variable won't be used in classifiers. You have to fix the problem in your dataset.");
                                nv = new SVarObj(nam + "." + vset.count());
                                if (vset.add(nv) < 0) {
                                    Common.addWarning("RTree.Load: Failed to create the substitute variable.");
                                    Common.addWarning("            Trying to use \"unknown.var." + vset.count() + "\" instead.");
                                    nv = new SVarObj("unknown.var." + vset.count());
                                    if (vset.add(nv) < 0) {
                                        Common.addWarning("RTree.Load: Failed to create even that variable. Somehting's terribly wrong. Expect more errors to follow.");
                                    }
                                }
                            }
                            nv.getNotifier().beginBatch();
                            if (!hasPoly) continue;
                            polySVs.add(nv);
                        }
                        gotNames = true;
                    }
                } else if (s.length() == 0 || isPoly) {
                    if (!isPoly && polyVars.size() > 0) {
                        isPoly = true;
                    }
                    if (isPoly) {
                        if (s.length() == 0) {
                            if (msid >= 0) {
                                double[] xx = new double[px.size()];
                                double[] yy = new double[px.size()];
                                for (int j = 0; j < xx.length; ++j) {
                                    xx[j] = (Double)px.elementAt(j);
                                    yy[j] = (Double)py.elementAt(j);
                                }
                                mses[msid].add(xx, yy, false);
                                msid = -1;
                                px.removeAllElements();
                                py.removeAllElements();
                            }
                        } else {
                            int t1 = s.indexOf("\t");
                            if (t1 > 0) {
                                String p1 = s.substring(0, t1);
                                s = s.substring(t1 + 1);
                                int t2 = s.indexOf("\t");
                                String p2 = null;
                                if (t2 > -1 || s.length() > 1 && s.charAt(0) == '/') {
                                    int j;
                                    if (t2 > -1) {
                                        p2 = s.substring(0, t2);
                                        s = s.substring(t2 + 1);
                                    } else {
                                        p2 = s;
                                    }
                                    if (msid >= 0) {
                                        double[] xx = new double[px.size()];
                                        double[] yy = new double[px.size()];
                                        for (int j2 = 0; j2 < xx.length; ++j2) {
                                            xx[j2] = (Double)px.elementAt(j2);
                                            yy[j2] = (Double)py.elementAt(j2);
                                        }
                                        mses[msid].add(xx, yy, false);
                                        msid = -1;
                                    }
                                    if (!p2.equals(curPolyVar)) {
                                        int i;
                                        if (curPolySV != null && mses != null) {
                                            SVarObj psv = new SVarObj(curPolySV.getName() + ".Map");
                                            psv.getNotifier().beginBatch();
                                            psv.setContentsType(8);
                                            for (int j3 = 0; j3 < mses.length; ++j3) {
                                                ((SVar)psv).add(mses[j3]);
                                            }
                                            if (vset != null) {
                                                vset.add(psv);
                                            }
                                            mses = null;
                                            px.removeAllElements();
                                            py.removeAllElements();
                                            curPolySV = null;
                                            curPolyVar = null;
                                            msid = -1;
                                            Loader.checkPolys(psv, vset);
                                        }
                                        for (i = 0; i < polyVars.size(); ++i) {
                                            String pv = (String)polyVars.elementAt(i);
                                            if (pv == null || !pv.equals(p2)) continue;
                                            curPolySV = (SVar)polySVs.elementAt(i);
                                            curPolyVar = p2;
                                            mses = new MapSegment[curPolySV.size()];
                                            px.removeAllElements();
                                            py.removeAllElements();
                                            break;
                                        }
                                        if (i >= polyVars.size()) {
                                            Common.addWarning("While processing polygons: Cannot find polygon variable \"" + p2 + "\". Ignoring further polygons.");
                                            isPoly = false;
                                        }
                                    }
                                    double vv = Tools.parseDouble(p1);
                                    for (j = 0; j < curPolySV.size(); ++j) {
                                        if ((!curPolySV.isNum() || curPolySV.atD(j) != vv) && curPolySV.atS(j).compareTo(p1) != 0) continue;
                                        msid = j;
                                        if (mses[j] != null) break;
                                        mses[j] = new MapSegment();
                                        break;
                                    }
                                    if (j >= curPolySV.size()) {
                                        Common.addWarning("While processing polygons: cannot find corresponding value \"" + p1 + "\" in variable \"" + p2 + "\". Ignoring this polygon.");
                                        msid = -1;
                                    }
                                    px.removeAllElements();
                                    py.removeAllElements();
                                    polyPt = 0;
                                } else {
                                    double x = Tools.parseDouble(p1);
                                    double y = Tools.parseDouble(s);
                                    px.add(new Double(x));
                                    py.add(new Double(y));
                                    ++polyPt;
                                }
                            }
                        }
                    }
                    if (!isPoly) {
                        if (curPolySV != null && mses != null) {
                            SVarObj psv = new SVarObj(curPolySV.getName() + ".Map");
                            psv.getNotifier().beginBatch();
                            for (int j = 0; j < mses.length; ++j) {
                                ((SVar)psv).add(mses[j]);
                            }
                            if (vset != null) {
                                vset.add(psv);
                            }
                            mses = null;
                            px.removeAllElements();
                            py.removeAllElements();
                            curPolySV = null;
                            curPolyVar = null;
                            msid = -1;
                            Loader.checkPolys(psv, vset);
                        }
                        gotData = true;
                        isData = false;
                        if (gotTree) {
                            sw.profile();
                            if (pd != null) {
                                pd.dispose();
                            }
                            if (vset != null) {
                                int i = prevars;
                                while (i < vset.count()) {
                                    vset.at(i++).getNotifier().endBatch();
                                }
                            }
                            return 0;
                        }
                    }
                } else {
                    if (dataSep == " " && s.indexOf("\"") > -1) {
                        StringBuffer sb = new StringBuffer(s);
                        int j = s.indexOf("\"");
                        while (j > -1) {
                            ++j;
                            while (j < s.length() && s.charAt(j) != '\"') {
                                if (s.charAt(j) == ' ') {
                                    sb.setCharAt(j, '_');
                                }
                                ++j;
                            }
                            if (j + 1 >= s.length()) {
                                j = -1;
                                continue;
                            }
                            j = s.indexOf("\"", j + 1);
                        }
                        s = sb.toString();
                    }
                    int i = 0;
                    StringTokenizer st = new StringTokenizer(s, dataSep);
                    while (st.hasMoreTokens()) {
                        if (i >= vset.count()) {
                            Common.addWarning("RTree.Load: row " + (vset.at(i).size() + 1) + " has more columns than the header. Ignoring exceeding column(s).");
                            break;
                        }
                        Object o = null;
                        String t = st.nextToken();
                        if ((t = t.trim()).length() > 0 && t.charAt(0) == '\"') {
                            t = t.substring(1, t.length() - 1);
                            if (rdsType && i > 0 && !vset.at(i).isCat()) {
                                vset.at(i).categorize();
                            }
                        }
                        boolean isnumber = false;
                        try {
                            Float f = null;
                            f = Float.valueOf(t);
                            if (t.indexOf(46) != -1) {
                                vset.at(i).add(f);
                            } else {
                                vset.at(i).add(new Integer(f.intValue()));
                            }
                            isnumber = true;
                        }
                        catch (NumberFormatException E) {
                            // empty catch block
                        }
                        if (!isnumber) {
                            if (vset.at(i).size() == vset.at(i).getMissingCount()) {
                                vset.at(i).categorize();
                            }
                            if (t.length() == 1 && (t.charAt(0) == '\u00a5' || t.charAt(0) == '\u2022') || t.compareTo("?") == 0 || t.compareTo("NA") == 0) {
                                vset.at(i).add(null);
                            } else if (!vset.at(i).add(t)) {
                                Common.addWarning("RTree.Load: row " + (vset.at(i).size() + 1) + ", column " + (i + 1) + " - non-numerical value (" + t + ") encountered in a numerical variable (" + vset.at(i).getName() + "). Value will be treated as missing.");
                                vset.at(i).add(null);
                            }
                        }
                        ++i;
                    }
                }
            }
            int pres = -1;
            if (!isTree) continue;
            if (gotData || vset == null) {
                sw.profile();
                if (pd != null) {
                    pd.dispose();
                }
                if (vset != null) {
                    int i = prevars;
                    while (i < vset.count()) {
                        vset.at(i++).getNotifier().endBatch();
                    }
                }
                return 0;
            }
            gotTree = true;
            isTree = false;
        }
        if (curPolySV != null && mses != null) {
            if (msid >= 0) {
                double[] xx = new double[px.size()];
                double[] yy = new double[px.size()];
                for (int j = 0; j < xx.length; ++j) {
                    xx[j] = (Double)px.elementAt(j);
                    yy[j] = (Double)py.elementAt(j);
                }
                mses[msid].add(xx, yy, false);
                msid = -1;
            }
            SVarObj psv = new SVarObj(curPolySV.getName() + ".Map");
            psv.setContentsType(8);
            for (int j = 0; j < mses.length; ++j) {
                ((SVar)psv).add(mses[j]);
            }
            if (vset != null) {
                vset.add(psv);
            }
            Loader.checkPolys(psv, vset);
        }
        sw.profile();
        if (pd != null) {
            pd.dispose();
        }
        if (vset != null) {
            int i = prevars;
            while (i < vset.count()) {
                vset.at(i++).getNotifier().endBatch();
            }
        }
        return 0;
    }

    public static int LoadTSV(BufferedReader r, SVarSet vset, boolean useFilter) {
        int line = 0;
        LoaderDelphiFilter f = null;
        try {
            int vsb = vset.count();
            String s = r.readLine();
            ++line;
            StringTokenizer st = new StringTokenizer(s, "\t");
            while (st.hasMoreTokens()) {
                String t = st.nextToken();
                SVarObj v = new SVarObj(t);
                vset.add(v);
            }
            int j = 0;
            if (useFilter) {
                f = new LoaderDelphiFilter(vset);
            }
            while (r.ready()) {
                String ls = r.readLine();
                ++line;
                if (ls == null || ls.length() == 0) break;
                StringTokenizer lst = new StringTokenizer(ls, "\t");
                if (useFilter) {
                    f.nextRecord();
                }
                int i = 0;
                while (lst.hasMoreTokens()) {
                    String t = lst.nextToken();
                    if (useFilter) {
                        f.addValue(vsb + i, t, line);
                    } else {
                        SVar v = vset.at(vsb + i);
                        v.add(t);
                    }
                    ++i;
                }
                ++j;
            }
            return j;
        }
        catch (IOException e) {
            System.out.println("Loader.LoadTSV[IOException]: " + e.getMessage());
            return 0;
        }
    }

    public static int LoadPolygons(BufferedReader r) {
        return 0;
    }
}

