/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.toolkit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import org.rosuda.JGR.toolkit.FontTracker;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.ibase.Common;

public class TextFinder
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -4833068209028584303L;
    private final Dimension screenSize = Common.screenRes;
    private final JTextField keyWordField = new JTextField();
    private final JButton searchButton = new JButton("Find");
    private final JButton cancelButton = new JButton("Cancel");
    private final JLabel status = new JLabel("                       ");
    private final TextFinder last = null;
    Highlighter.HighlightPainter highLighter = new FoundHighlighter(SystemColor.textHighlight);
    private JTextComponent searchArea = null;
    private String keyWord = null;
    private int position = -1;
    private boolean found = false;

    public TextFinder() {
        this((JTextComponent)null);
    }

    public TextFinder(JTextComponent searchArea) {
        this.setTitle("Find");
        this.searchArea = searchArea;
        Dimension d = new Dimension(80, 25);
        this.searchButton.setActionCommand("search");
        this.searchButton.addActionListener(this);
        this.searchButton.setMaximumSize(d);
        this.searchButton.setMinimumSize(d);
        this.searchButton.setPreferredSize(d);
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setMaximumSize(d);
        this.cancelButton.setPreferredSize(d);
        this.cancelButton.setMinimumSize(d);
        FontTracker.current.add(this.keyWordField);
        this.keyWordField.setFont(JGRPrefs.DefaultFont);
        this.keyWordField.setMaximumSize(new Dimension(300, 25));
        this.keyWordField.setMinimumSize(new Dimension(300, 25));
        this.keyWordField.setPreferredSize(new Dimension(300, 25));
        JPanel top = new JPanel();
        top.add(this.keyWordField);
        JPanel bottom = new JPanel(new FlowLayout(2));
        bottom.add(this.status);
        bottom.add(this.searchButton);
        bottom.add(this.cancelButton);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)top, "Center");
        this.getContentPane().add((Component)bottom, "South");
        this.getRootPane().setDefaultButton(this.searchButton);
        this.setSize(new Dimension(320, 95));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                TextFinder.this.exit();
            }
        });
        this.setResizable(false);
    }

    private void exit() {
        this.removeHighlights(this.searchArea);
        this.setVisible(false);
    }

    public void setSearchArea(JTextComponent comp) {
        this.searchArea = comp;
    }

    private void find() {
        if (this.searchArea == null) {
            return;
        }
        this.searchArea.requestFocus();
        if (this.keyWord != null && !this.keyWord.equals(this.keyWordField.getText().toLowerCase().trim())) {
            this.position = -1;
            this.found = false;
        }
        this.keyWord = this.keyWordField.getText().toLowerCase().trim();
        this.searchArea.selectAll();
        String cleanDoc = this.searchArea.getSelectedText();
        if (!this.keyWord.equals("")) {
            this.position = cleanDoc.toLowerCase().indexOf(this.keyWord, this.position + 1);
            if (this.position == -1) {
                if (!this.found) {
                    this.status.setText("No found!              ");
                } else {
                    this.status.setText("No more results!       ");
                }
                this.found = false;
            } else {
                this.status.setText("                       ");
                this.highlight(this.searchArea, this.position, this.position + this.keyWord.length());
                this.searchArea.select(this.position, this.position);
                this.found = true;
            }
        }
        this.toFront();
        this.requestFocus();
    }

    private void highlight(JTextComponent textComp, int off, int end2) {
        this.removeHighlights(textComp);
        try {
            Highlighter hilite = textComp.getHighlighter();
            hilite.addHighlight(off, end2, this.highLighter);
        }
        catch (BadLocationException e) {
            // empty catch block
        }
    }

    private void removeHighlights(JTextComponent textComp) {
        Highlighter hilite = textComp.getHighlighter();
        Highlighter.Highlight[] hilites = hilite.getHighlights();
        for (int i = 0; i < hilites.length; ++i) {
            if (!(hilites[i].getPainter() instanceof FoundHighlighter)) continue;
            hilite.removeHighlight(hilites[i]);
        }
    }

    private void showFinder() {
        this.keyWordField.requestFocus();
        this.setLocation((this.screenSize.width - 400) / 2, (this.screenSize.height - 100) / 2);
        super.setVisible(true);
        super.toFront();
    }

    public TextFinder showFind(boolean next) {
        if (!next) {
            this.keyWordField.setText(null);
            this.keyWord = null;
            this.position = -1;
            this.found = false;
            this.showFinder();
        } else {
            this.keyWordField.setText(this.keyWord);
            this.showFinder();
            this.find();
        }
        return this.last;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd == "cancel") {
            this.exit();
        } else if (cmd == "search") {
            this.find();
        }
    }

    class FoundHighlighter
    extends DefaultHighlighter.DefaultHighlightPainter {
        public FoundHighlighter(Color color) {
            super(color);
        }
    }
}

