/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.browser;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellRenderer;
import org.rosuda.JGR.browser.BrowserNode;
import org.rosuda.JGR.browser.HeadNode;
import org.rosuda.JGR.browser.Refresher;

public class BrowserTree
extends JTree {
    static int nodeOffset = -1;
    HeadNode head;
    DefaultTreeModel mod;
    Refresher ref;

    public BrowserTree() {
        if (nodeOffset == -1) {
            nodeOffset = (Integer)UIManager.get("Tree.rightChildIndent") + (Integer)UIManager.get("Tree.leftChildIndent");
        }
        this.head = new HeadNode();
        this.mod = new DefaultTreeModel(this.head);
        this.setModel(this.mod);
        this.getSelectionModel().setSelectionMode(1);
        this.putClientProperty("JTree.lineStyle", "None");
        this.setCellRenderer(new BrowserCellRenderer());
        new Thread(new Runnable(){

            public void run() {
                BrowserTree.this.head.update(BrowserTree.this.mod);
            }
        }).start();
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20));
        this.repaint();
        ExpandListener lis = new ExpandListener();
        this.addTreeWillExpandListener(lis);
        this.addTreeExpansionListener(lis);
        TreeMouseListener mlis = new TreeMouseListener();
        this.addMouseListener(mlis);
        this.setRowHeight(0);
        this.setToggleClickCount(1000);
    }

    public void startRefresher() {
        if (this.ref != null) {
            return;
        }
        this.ref = new Refresher(this.mod);
        new Thread(this.ref).start();
    }

    public void stopRefresher() {
        if (this.ref != null) {
            this.ref.stopRunning();
            this.ref = null;
        }
    }

    class TreeMouseListener
    implements MouseListener {
        TreeMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                int row = BrowserTree.this.getClosestRowForLocation(e.getX(), e.getY());
                BrowserTree.this.setSelectionRow(row);
                final BrowserNode node = (BrowserNode)BrowserTree.this.getSelectionPath().getLastPathComponent();
                new Thread(new Runnable(){

                    public void run() {
                        node.editObject();
                    }
                }).start();
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent arg0) {
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.pop(e);
            } else {
                int wid = BrowserTree.this.getParent().getWidth();
                if (e.getX() < wid - nodeOffset && e.getX() >= wid - nodeOffset * 2) {
                    this.pop(e);
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.pop(e);
            }
        }

        private void pop(MouseEvent e) {
            int row = BrowserTree.this.getClosestRowForLocation(e.getX(), e.getY());
            BrowserTree.this.setSelectionRow(row);
            JPopupMenu popupMenu = ((BrowserNode)BrowserTree.this.getSelectionPath().getLastPathComponent()).getPopupMenu();
            if (popupMenu != null) {
                popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    class ExpandListener
    implements TreeWillExpandListener,
    TreeExpansionListener {
        ExpandListener() {
        }

        public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
        }

        public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
            final BrowserNode node = (BrowserNode)event.getPath().getLastPathComponent();
            new Thread(new Runnable(){

                public void run() {
                    node.setExpanded(true);
                    node.update(((ExpandListener)ExpandListener.this).BrowserTree.this.mod);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ((ExpandListener)(this).ExpandListener.this).BrowserTree.this.mod.reload(node);
                        }
                    });
                }
            }).start();
        }

        public void treeCollapsed(TreeExpansionEvent event) {
            final BrowserNode node = (BrowserNode)event.getPath().getLastPathComponent();
            new Thread(new Runnable(){

                public void run() {
                    node.setExpanded(false);
                    node.update(((ExpandListener)ExpandListener.this).BrowserTree.this.mod);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ((ExpandListener)(this).ExpandListener.this).BrowserTree.this.mod.reload(node);
                        }
                    });
                }
            }).start();
        }

        public void treeExpanded(TreeExpansionEvent event) {
        }
    }

    class BrowserCellRenderer
    implements TreeCellRenderer {
        BrowserCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            BrowserNode node = (BrowserNode)value;
            return node.getRenderer().getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
    }
}

