/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase;

import java.util.Enumeration;
import java.util.Vector;
import org.rosuda.ibase.Commander;
import org.rosuda.ibase.Notifier;
import org.rosuda.ibase.NotifyMsg;
import org.rosuda.ibase.SVarSet;

public class SMarker
extends Notifier
implements Commander {
    public static final int MASK_PRIMARY = 0;
    public static final int MASK_SECONDARY = 1;
    public static final int MASK_RAW = 2;
    int[] mask;
    int msize;
    Vector list;
    int maxMark;
    int secMarked = 0;
    SVarSet masterSet;

    public SMarker(int reqsize) {
        this.mask = new int[reqsize];
        this.list = new Vector();
        this.msize = reqsize;
        this.masterSet = null;
        this.maxMark = 1;
    }

    public void resize(int newsize) {
        if (newsize < this.msize) {
            return;
        }
        this.list.removeAllElements();
        this.mask = new int[newsize];
        this.list = new Vector();
        this.msize = newsize;
        this.masterSet = null;
        this.maxMark = 1;
        this.secMarked = 0;
    }

    public int size() {
        return this.msize;
    }

    public int marked() {
        return this.list.size();
    }

    public int get(int pos) {
        return pos < 0 || pos >= this.msize ? 0 : ((this.mask[pos] & 1) == 1 ? -1 : this.mask[pos] >> 1);
    }

    public int getSec(int pos) {
        return pos < 0 || pos >= this.msize ? 0 : this.mask[pos] >> 1;
    }

    public boolean at(int pos) {
        return pos >= 0 && pos < this.msize && (this.mask[pos] & 1) == 1;
    }

    public Vector getList() {
        return this.list;
    }

    public int[] getSelectedIDs() {
        int j = this.list.size();
        int[] l = new int[j];
        for (int i = 0; i < j; ++i) {
            l[i] = (Integer)this.list.elementAt(i);
        }
        return l;
    }

    public int[] getMaskCopy(int maskType) {
        int i;
        int[] mc = new int[this.mask.length];
        System.arraycopy(this.mask, 0, mc, 0, this.mask.length);
        if (maskType == 0) {
            for (i = 0; i < mc.length; ++i) {
                if ((mc[i] & 1) != 1) continue;
                mc[i] = -1;
            }
        }
        if (maskType == 1) {
            i = 0;
            while (i < mc.length) {
                int n = i++;
                mc[n] = mc[n] >> 1;
            }
        }
        return mc;
    }

    public void set(int pos, boolean pMark) {
        if (pos < 0 || pos >= this.msize) {
            return;
        }
        if (pMark == ((this.mask[pos] & 1) == 1)) {
            return;
        }
        if ((this.mask[pos] & 1) == 0 && pMark) {
            this.list.addElement(new Integer(pos));
        }
        if ((this.mask[pos] & 1) == 1 && !pMark) {
            this.list.removeElement(new Integer(pos));
        }
        int n = pos;
        this.mask[n] = this.mask[n] ^ 1;
    }

    public void setSec(int pos, int mark) {
        if (mark > this.maxMark) {
            this.maxMark = mark;
        }
        if ((mark <<= 1) > 0 && this.mask[pos] >> 1 == 0) {
            ++this.secMarked;
        } else if (mark == 0 && this.mask[pos] >> 1 > 0) {
            --this.secMarked;
        }
        this.mask[pos] = this.mask[pos] & 1 | mark;
    }

    public void setSelected(int mark) {
        if (mark > this.maxMark) {
            this.maxMark = mark;
        }
        mark <<= 1;
        Enumeration e = this.list.elements();
        while (e.hasMoreElements()) {
            Integer i = (Integer)e.nextElement();
            if (i == null) continue;
            int id = i;
            if (mark > 0 && this.mask[id] >> 1 == 0) {
                ++this.secMarked;
            } else if (mark == 0 && this.mask[id] >> 1 > 0) {
                --this.secMarked;
            }
            this.mask[id] = this.mask[id] & 1 | mark;
        }
    }

    public int getMaxMark() {
        return this.maxMark;
    }

    public int getSecCount() {
        return this.secMarked;
    }

    public Enumeration elements() {
        return this.list.elements();
    }

    public void selectNone() {
        int i = 0;
        while (i < this.msize) {
            int n = i++;
            this.mask[n] = this.mask[n] & 0xFFFFFFFE;
        }
        this.list.removeAllElements();
    }

    public void selectAll() {
        this.list.removeAllElements();
        int i = 0;
        while (i < this.msize) {
            this.list.addElement(new Integer(i));
            int n = i++;
            this.mask[n] = this.mask[n] | 1;
        }
    }

    public void selectInverse() {
        for (int i = 0; i < this.msize; ++i) {
            if ((this.mask[i] & 1) == 0) {
                this.list.addElement(new Integer(i));
                int n = i;
                this.mask[n] = this.mask[n] | 1;
                continue;
            }
            this.list.removeElement(new Integer(i));
            int n = i;
            this.mask[n] = this.mask[n] & 0xFFFFFFFE;
        }
    }

    public void resetSec() {
        if (this.secMarked > 0) {
            int i = 0;
            while (i < this.msize) {
                int n = i++;
                this.mask[n] = this.mask[n] & 1;
            }
        }
        this.maxMark = 1;
        this.secMarked = 0;
    }

    public SVarSet getMasterSet() {
        return this.masterSet;
    }

    public Object run(Object o, String cmd) {
        if (cmd == "selAll") {
            this.selectAll();
            this.NotifyAll(new NotifyMsg(this, 4096));
        }
        if (cmd == "selNone") {
            this.selectNone();
            this.NotifyAll(new NotifyMsg(this, 4096));
        }
        if (cmd == "selInv") {
            this.selectInverse();
            this.NotifyAll(new NotifyMsg(this, 4096));
        }
        return null;
    }

    public void setSecBySelection(int markSel, int markNonsel) {
        int i;
        boolean[] ids = new boolean[this.mask.length];
        int[] selIds = this.getSelectedIDs();
        for (i = 0; i < selIds.length; ++i) {
            this.setSec(selIds[i], markSel);
            ids[selIds[i]] = true;
        }
        for (i = 0; i < ids.length; ++i) {
            if (ids[i]) continue;
            this.setSec(i, markNonsel);
        }
    }
}

