/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.editor;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import org.rosuda.JGR.editor.SyntaxDocument;
import org.rosuda.JGR.toolkit.FontTracker;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.JGR.util.ErrorMsg;

public class SyntaxArea
extends JTextPane
implements CaretListener,
DropTargetListener {
    private static final long serialVersionUID = -1025997191896098082L;
    private HighlightPainter ParanthesisHighlightMissing = new HighlightPainter(JGRPrefs.ERRORColor);
    private HighlightPainter ParanthesisHighlight = new HighlightPainter(JGRPrefs.BRACKETHighLight);
    private boolean wrap = true;

    public SyntaxArea() {
        this.setContentType("text/rtf");
        this.setDocument(new SyntaxDocument());
        if (FontTracker.current == null) {
            FontTracker.current = new FontTracker();
        }
        FontTracker.current.add(this);
        this.addCaretListener(this);
        this.setDragEnabled(true);
    }

    public void append(String str) {
        this.append(str, null);
    }

    public void append(String str, AttributeSet attr) {
        try {
            Document doc = this.getDocument();
            doc.insertString(doc.getLength(), str, attr);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void insertAt(int offset, String str) {
        try {
            Document doc = this.getDocument();
            doc.insertString(offset, str, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public String getText() {
        try {
            Document doc = this.getDocument();
            return doc.getText(0, doc.getLength());
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    public void setText(String str) {
        try {
            Document doc = this.getDocument();
            doc.remove(0, doc.getLength());
            doc.insertString(0, str, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public String getText(int offs, int len) {
        try {
            Document doc = this.getDocument();
            return doc.getText(offs, len);
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    public void cut() {
        this.removeCaretListener(this);
        super.cut();
        this.addCaretListener(this);
    }

    public void copy() {
        this.removeCaretListener(this);
        super.copy();
        this.addCaretListener(this);
    }

    public void paste() {
        this.removeCaretListener(this);
        super.paste();
        this.addCaretListener(this);
    }

    protected int getLineCount() {
        Element map = this.getDocument().getDefaultRootElement();
        return map.getElementCount();
    }

    protected int getLineStartOffset(int line) throws BadLocationException {
        int lineCount = this.getLineCount();
        if (line < 0) {
            throw new BadLocationException("Negative line", -1);
        }
        if (line >= lineCount) {
            throw new BadLocationException("No such line", this.getDocument().getLength() + 1);
        }
        Element map = this.getDocument().getDefaultRootElement();
        Element lineElem = map.getElement(line);
        return lineElem.getStartOffset();
    }

    protected int getLineEndOffset(int line) throws BadLocationException {
        int lineCount = this.getLineCount();
        if (line < 0) {
            throw new BadLocationException("Negative line", -1);
        }
        if (line >= lineCount) {
            throw new BadLocationException("No such line", this.getDocument().getLength() + 1);
        }
        Element map = this.getDocument().getDefaultRootElement();
        Element lineElem = map.getElement(line);
        int endOffset = lineElem.getEndOffset();
        return line == lineCount - 1 ? endOffset - 1 : endOffset;
    }

    protected int getLineOfOffset(int offset) throws BadLocationException {
        Document doc = this.getDocument();
        if (offset < 0) {
            throw new BadLocationException("Can't translate offset to line", -1);
        }
        if (offset > doc.getLength()) {
            throw new BadLocationException("Can't translate offset to line", doc.getLength() + 1);
        }
        Element map = this.getDocument().getDefaultRootElement();
        return map.getElementIndex(offset);
    }

    public boolean getWordWrap() {
        return this.wrap;
    }

    public void setWordWrap(boolean wrap) {
        this.wrap = wrap;
    }

    public boolean getScrollableTracksViewportWidth() {
        if (!this.wrap) {
            Container parent = this.getParent();
            TextUI ui1 = this.getUI();
            boolean bool = parent == null || ui1.getPreferredSize((JComponent)this).width < parent.getSize().width;
            return bool;
        }
        return super.getScrollableTracksViewportWidth();
    }

    public void setBounds(int x, int y, int width, int height) {
        if (this.wrap) {
            super.setBounds(x, y, width, height);
        } else {
            Dimension size = this.getPreferredSize();
            super.setBounds(x, y, Math.max(size.width, width), Math.max(size.height, height));
        }
    }

    public boolean isEscaped(int pos) {
        boolean escaped = false;
        try {
            escaped = this.lastChar(pos - 1, "\\");
        }
        catch (Exception e) {
            escaped = false;
        }
        return escaped;
    }

    public boolean lastChar(int pos, String cont) {
        if (pos == 0) {
            return false;
        }
        return this.getText(pos - 1, 1) != null && this.getText(pos - 1, 1).equals(cont);
    }

    public void highlightParanthesisForward(String par, int pos) throws BadLocationException {
        int open = pos;
        int cend = this.getText().length();
        String end2 = null;
        if (par.equals("{")) {
            end2 = "}";
        }
        if (par.equals("(")) {
            end2 = ")";
        }
        if (par.equals("[")) {
            end2 = "]";
        }
        if (end2 == null) {
            return;
        }
        String cchar = null;
        int pcount = 1;
        int line = this.getLineOfOffset(open);
        int lend = this.getLineEndOffset(line);
        while (++pos <= cend) {
            cchar = this.getText(pos - 1, 1);
            if (cchar.matches("\"") && !this.isEscaped(pos)) {
                boolean found = true;
                int i = pos;
                while (++i <= lend) {
                    found = false;
                    String schar = this.getText(i - 1, 1);
                    if (!schar.equals("\"") || this.isEscaped(i)) continue;
                    pos = i;
                    found = true;
                    break;
                }
                if (found) continue;
                return;
            }
            if (cchar.matches("[(]|[\\[]|[{]") && !this.isEscaped(pos)) {
                ++pcount;
                continue;
            }
            if (!cchar.matches("[)]|[\\]]|[}]") || this.isEscaped(pos) || --pcount != 0) continue;
            if (cchar.equals(end2)) {
                this.highlight(this, par, open, this.ParanthesisHighlight);
                this.highlight(this, end2, pos, this.ParanthesisHighlight);
            } else {
                this.highlight(this, par, open, this.ParanthesisHighlightMissing);
                this.highlight(this, end2, pos, this.ParanthesisHighlightMissing);
            }
            return;
        }
    }

    public void highlightParanthesisBackward(String par, int pos) throws BadLocationException {
        int end2 = pos;
        String open = null;
        if (par.equals("}")) {
            open = "{";
        }
        if (par.equals(")")) {
            open = "(";
        }
        if (par.equals("]")) {
            open = "[";
        }
        if (open == null) {
            return;
        }
        String cchar = null;
        int pcount = 1;
        int line = this.getLineOfOffset(end2);
        int lstart = this.getLineStartOffset(line);
        while (--pos > 0) {
            cchar = this.getText(pos - 1, 1);
            if (cchar.matches("\"") && !this.isEscaped(pos)) {
                boolean found = true;
                int i = pos;
                while (--i > lstart) {
                    found = false;
                    String schar = this.getText(i - 1, 1);
                    if (!schar.equals("\"") || this.isEscaped(i)) continue;
                    pos = i;
                    found = true;
                    break;
                }
                if (found) continue;
                return;
            }
            if (cchar.matches("[)]|[\\]]|[}]") && !this.isEscaped(pos)) {
                ++pcount;
                continue;
            }
            if (!cchar.matches("[(]|[\\[]|[{]") || this.isEscaped(pos) || --pcount != 0) continue;
            if (cchar.equals(open)) {
                this.highlight(this, par, end2, this.ParanthesisHighlight);
                this.highlight(this, open, pos, this.ParanthesisHighlight);
            } else {
                this.highlight(this, par, end2, this.ParanthesisHighlightMissing);
                this.highlight(this, open, pos, this.ParanthesisHighlightMissing);
            }
            return;
        }
    }

    public void highlight(JTextComponent textComp, String pattern, int pos, HighlightPainter hipainter) {
        try {
            Highlighter hilite = textComp.getHighlighter();
            if (pos == 0) {
                ++pos;
            }
            hilite.addHighlight(pos - 1, pos, hipainter);
        }
        catch (BadLocationException e) {
            // empty catch block
        }
    }

    public void removeHighlights() {
        Highlighter hilite = this.getHighlighter();
        Highlighter.Highlight[] hilites = hilite.getHighlights();
        for (int i = 0; i < hilites.length; ++i) {
            if (!(hilites[i].getPainter() instanceof HighlightPainter)) continue;
            hilite.removeHighlight(hilites[i]);
        }
    }

    public void caretUpdate(CaretEvent e) {
        block11: {
            SyntaxArea sa = this;
            this.removeHighlights();
            try {
                String c;
                int pos;
                if (e.getDot() == 0) {
                    return;
                }
                if (!this.getText(e.getDot() - 1, 1).matches("[(]|[\\[]|[{]|[)]|[\\]]|[}]")) break block11;
                this.removeCaretListener(sa);
                try {
                    pos = e.getDot();
                    c = this.getText(pos - 1, 1);
                    if (sa.isEscaped(pos)) {
                        this.addCaretListener(sa);
                        return;
                    }
                }
                catch (Exception ex1) {
                    new ErrorMsg(ex1);
                    this.addCaretListener(sa);
                    return;
                }
                try {
                    if (c.matches("[(]|[\\[]|[{]")) {
                        this.highlightParanthesisForward(c, pos);
                    } else if (c.matches("[)]|[\\]]|[}]")) {
                        this.highlightParanthesisBackward(c, pos);
                    }
                }
                catch (Exception ex2) {
                    new ErrorMsg(ex2);
                }
                this.addCaretListener(sa);
            }
            catch (Exception ex3) {
                new ErrorMsg(ex3);
            }
        }
    }

    public void dragEnter(DropTargetDragEvent evt) {
    }

    public void dragOver(DropTargetDragEvent evt) {
    }

    public void dragExit(DropTargetEvent evt) {
    }

    public void dropActionChanged(DropTargetDragEvent evt) {
    }

    public void drop(DropTargetDropEvent evt) {
        try {
            Transferable t = evt.getTransferable();
            if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                evt.acceptDrop(3);
                evt.getDropTargetContext().dropComplete(true);
            } else {
                evt.rejectDrop();
            }
        }
        catch (Exception e) {
            evt.rejectDrop();
        }
    }

    class HighlightPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        public HighlightPainter(Color color) {
            super(color);
        }
    }
}

